/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#define USE_OR_MASKS			//timers.h-ben "VAGY" mvelettel egyesthet makrk legyenek
#include "timers.h"				//makrk s fggvnydek az idztkhz  

/** \file
*  Ngyszghullm jelet llt el az RB5 kimeneten, Timer2-vel keltett periodikus 
*  programmegszakts segtsgvel.  A programban gy konfigurljuk a Timer2  idztt, hogy 5 ms-onknt generljon programmegszaktst. 
* Az interrupt kiszolglsakor trljk a TMR2IF jelzbitet s ellenkez llapotba billentjk az RB5 kimenetet. 
* Mellkfelttelknt egy delay nev szmllt is cskkentjk minden 5 ms-os idszelet elteltekor, amg a szmll nullra nem cskken. 
* A szmllsra hasznlt vltoz szemaforknt hasznosthat: nulla llapota jelzi, hogy letelt az elrt ksleltetsi id. 
* A szemafort a fprogramban LED1 villogtatsra hasznljuk "letjelz" funkciknt.
*
*<b>Hardver kvetelmnyek:</b> a "A ksrleti ramkr" cm fejezetben bemutatott referencia ramkr RB5 kimenett r kell ktni 
*egy oszcilloszkpra, vagy logikai analiztorra (a PICkit2 is hasznlhat logikai analiztorknt). Ha nincs alkalmas eszkznk a 
* vizsglathoz, akkor kzvetett mdon a LED1 villogsa is jelzi, hogy rendben zajlanak a programmegszaktsok.
*
*<b>Projekt konfigurci:</b> A program helyes mkdshez a HID_BOOTLOADER mellett a USE_INTERRUPT szimblumot is definilni kell! Az USB kapcsolatot nem hasznljuk.
*/

volatile unsigned char delay;	///<szmll ksletetshez

//--Timer2 interrupt kiszolglsa
#pragma interrupt hi_isr
void hi_isr(void) {
	_asm  btg LATB,5,ACCESS _endasm	//tbillent RB5 llapott 
	PIR1bits.TMR2IF = 0;		//trli az interrupt jelzbitet
	if(delay) delay--;			//szmll cskkents, amg delay > 0
}

#pragma interruptlow lo_isr
void lo_isr() {
}

void main (void) {
	mInitAllLEDs();
	TRISBbits.TRISB5=0;			//RB5
//-- Timer2 konfigurlsa 200 Hz-es 
//-- (5 ms-os) peridikus megszaktsra
	IPR1bits.TMR2IP=1;			//Timer2 megszakts magas priorits
	PR2 = 249;					//peridus regiszter belltsa (250 - 1)
	OpenTimer2(TIMER_INT_ON | T2_PS_1_16 | T2_POST_1_15 );
	RCONbits.IPEN=1;			//Ktszint megszaktsi md belltsa
	INTCONbits.GIEH=1;			//A magas priorits interrupt engedlyezse
	INTCONbits.GIEL=0;			//Az alacsony priorits interrupt tiltsa

//-- Az interrupt elvgzi a tbbi munkt
	while (1) {
    	mLED_1_Toggle();		//Ledvillogtatssal jelezzk, hogy fut a program
		delay=50;				//delay = 50 * 5 ms
		while(delay);			//vrunk, amg nullzdik
  	}
}
