/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"

/** \file
 *  Pldaprogram nyomgomb pergsnek ellenrzsre.
 *  
 *  Az SW1 nyomgombhoz tartoz bemeneten a bemeneti szint megvltozsra 
 *  bekvetkez programmegszaktst engedlyezzk. A programmegszakts kiszolglsakor
 *  szmlljuk a bekvetkez megszaktsokat. A fprogramban a szoksos mdon, ksleltetssel 
 *  oldjuk meg a pergsmentestst, s minden lenyoms/felengeds ciklus utn ellenrizzk a
 *  a kzben bekvetkezett megszaktsok szmt. Ha kettnl tbb megszakts volt, akkor 
 *  kontaktuspergs trtnt.
 *
 *  Hardver kvetelmnyek: a program az "A ksrleti ramkr" cm fejezetben bemutatott referencia 
 *  ramkrkn fut, az ramkr kiegsztsre/bvtsre nincs szksg.
 *
 *  Projekt konfigurci: A program mkdshez a HID_BOOTLOADER szimblumon kvl az USE_USB 
 *  valamint az USE_INTERRPT szimblumokat is definilni kell.
 */

volatile int counter;
volatile char c;

//-- INTERRUPT KISZOLGL ELJRSOK ---------

///Magas priorits programmegszakts kiszolglsa
    #pragma interrupt hi_isr
    void hi_isr() {
        USBDeviceTasks();              //--- USB programmegszakts kiszolglsa
    }
///Alacsony priorits programmegszakts kiszolglsa
    #pragma interruptlow lo_isr
    void lo_isr() {                    //RA3 megvltozst jelz megszakts
    #if defined(__18F4550)
        c=PORTB;                       //PORTB jraolvassa sznteti meg a kivlt okot
        INTCONbits.RBIF=0;             //az interrupt jelzbit trlse
    #elif defined(__18F14K50)
        c=PORTA;                       //PORTA jraolvassa sznteti meg a kivlt okot
        INTCONbits.RABIF=0;            //az interrupt jelzbit trlse
    #endif
        counter++;                     //szmlljuk a megszaktsokat
    }


//-- Fprogram ----------------------
void main(void) {
    unsigned int my_counts;            //counter tartalmnak msolata lesz benne
    InitializeSystem();
    RCONbits.IPEN=1;                   //Ktszint megszaktsi md belltsa
    INTCONbits.GIEL=1;                 //Alacsony priorits interrupt engedlyezse
//-- kivrjuk az els karakter berkezst
    while (!usb_cdc_kbhit()) {
        ProcessIO();
    }
    outString("bounce_test.c program,  ");
//-- az SW1-hez tartoz bemeneten a megvltozst jelz interrupt engedlyezse 
    #if defined(__18F4550)
        TRISB=0xFF;                    //legyen a B port minden lba digitlis bemenet
        INTCON2bits.RBPU=0;            //legyen B port minden lba felhzva (ne lebegjen)
        c = PORTB;                     //PORTB olvassa trli a korbbi bellst						
        INTCONbits.RBIF=0;             //az IOCB interrupt jelzbit trlse
        INTCON2bits.RBIP=0;            //RBIF legyen alacsony priorits 
        INTCONbits.RBIE=1;             //a vltozsjelz interrupt engedlyezse        
        outString("PICCOLO-4550\n");
    #elif defined(__18F14K50)
        IOCAbits.IOCA3=1;              //RA3 vltozsjelz interrupt engedlyezse
        c = PORTA;                     //PORTA bellsa trli a korbbi bellst
        INTCONbits.RABIF=0;            //az interrupt jelzbit trlse
        INTCON2bits.RABIP=0;           //RABIF legyen alacsony priorits 
        INTCONbits.RABIE=1;            //a vltozsjelz interrupt engedlyezse
        outString("PICCOLO-14K50\n");
    #endif
    while (1) {
        outString("Nyomja le s engedje fel SW1-et! ... ");
        counter = 0;                   //nullzzuk a szmllt
        while(SW1==1) ProcessIO();     //--- lenyomsra vr
        delay_ms(20);                  //pergsmentest ksleltets
        while(SW1==0) ProcessIO();     //--- felengedsre vr
        delay_ms(20);                  //pergsmentest ksleltets
        my_counts=counter;             //msolatot ksztnk
        out4hex(my_counts);            //megszaktsok szma
        outString(" megszakts volt, SW1 ");
        if(my_counts<3) outString("nem ");
        outString("pergett\n");
  }
}
