;------------------------------------------------------
; PICCOLO project
; Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
;
; Mintaprogram az rtkadst segt makrk hasznlatnak 
; bemutatsra (LET8, LET16, LET32)
;
; FIGYELEM: A programot az MPLAB szimultorban futtassuk! 
;------------------------------------------------------

#include "..\include\p18_all.inc"

;******************************************************
; Helyfoglals a vltozk szmra
; Szndkosan az ACCESS terleten kvl helyeztk el a 
; vltozkat, hogy a BANKED md elrst tesztelhessk. 
;******************************************************
mydata		udata 0x120
my_byte		res 1
my_word		res 2
my_dword	res 4	

;***************************************************	
; LET32 - 32-bites eljel nlkli rtkads
;  valtozo: az eljel nlkli vltoz cme
;     adat: a vltozba rand adat (0 - 0xffffffff)
;
; Plda: 
;		LET32	my_dword,D'573612400'
;***************************************************
LET32	macro	valtozo,adat
		banksel	valtozo
		movlw	adat & H'FF'
		movwf	valtozo
		movlw	adat >>D'8' & H'FF'
		movwf	valtozo+1
		movlw	adat >>D'16' & H'FF'
		movwf	valtozo+2
		movlw	adat >>D'24' & H'FF'
		movwf	valtozo+3
		endm
;***************************************************	
; LET16 - 16-bites eljel nlkli rtkads
;  valtozo: az eljel nlkli vltoz cme
;     adat: a vltozba rand adat (0 - 0xffff)
;
; Plda: 
;		LET16	my_word,D'57360'
;***************************************************
LET16	macro	valtozo,adat
		banksel	valtozo
		movlw	adat & H'FF'
		movwf	valtozo
		movlw	adat >>D'8' & H'FF'
		movwf	valtozo+1
		endm

;***************************************************	
; LET8 - 8-bites eljel nlkli rtkads
;  valtozo: az eljel nlkli vltoz cme
;     adat: a vltozba rand adat (0 - 0xff)
;
; Plda: 
;		LET8	my_byte,D'160'
;***************************************************
LET8	macro	valtozo,adat
		banksel	valtozo
		movlw	adat 
		movwf	valtozo
		endm

PGM      CODE
;--- A fprogram ktelezen a main cmknl kezddik!
main:	LET32 	my_dword,H'553175FF'
		LET16	my_word,D'13572'
		LET8	my_byte,D'37'
		goto $
		end