;------------------------------------------------------
; PICCOLO project
; Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
;
; Mintaprogram a jobbra lptetst vgz makrk  
; hasznlatnak bemutatsra
;
; FIGYELEM: A programot az MPLAB szimultorban futtassuk! 
;------------------------------------------------------

#include "..\include\p18_all.inc"

;******************************************************
; Helyfoglals a vltozk szmra
; Szndkosan az ACCESS terleten kvl helyeztk el a 
; vltozkat, hogy a BANKED md elrst tesztelhessk. 
;******************************************************
mydata		udata 0x120
my_byte		res 1
my_word		res 2
my_dword	res 4	

;***************************************************	
; 32-bites logikai lptets jobbra
;  valtozo:  a lptetni kvnt vltoz cme
;    lepes:  a lptetsek szma (1-31)
;***************************************************
JOBBRA_LEP32	macro	valtozo,lepes
	variable i=lepes
	banksel	valtozo
	while i
		bcf STATUS,C   	; trljk a Carry bitet
		rrcf valtozo+3		; az MSB lptetse
		rrcf valtozo+2		; a 3. bjt lptetse
		rrcf valtozo+1		; a 2. bjt lptetse
		rrcf valtozo		; az LSB lptetse
	variable i = i-1
	endw
	endm

;***************************************************	
; 16-bites logikai lptets jobbra
;  valtozo: a lptetni kvnt vltoz cme
;    lepes: a lptetsek szma (1-15)
;
; Plda:
;		JOBBRA_LEP16 my_word,3
;***************************************************
JOBBRA_LEP16	macro	valtozo,lepes
	variable i=lepes
	banksel	valtozo
	while i
		bcf STATUS,C   	; trljk a Carry bitet
		rrcf valtozo+1		; a 2. bjt lptetse
		rrcf valtozo		; az LSB lptetse
	variable i = i-1
	endw
	endm

;***************************************************	
; 8-bites logikai lptets jobbra
;  valtozo: a lptetni kvnt vltoz cme
;    lepes: a lptetsek szma (1-7)
;
; Plda:
;		JOBBRA_LEP8 my_byte,3
;***************************************************
JOBBRA_LEP8	macro	valtozo,lepes
	variable i=lepes
	banksel	valtozo
	while i
		bcf STATUS,C   	; trljk a Carry bitet
		rrcf valtozo	; a vltoz lptetse
	variable i = i-1
	endw
	endm

;***************************************************	
; LET32 - 32-bites eljel nlkli rtkads
;  valtozo: az eljel nlkli vltoz cme
;     adat: a vltozba rand adat (0 - 0xffffffff)
;
; Plda: 
;		LET32	my_dword,D'573612400'
;***************************************************
LET32	macro	valtozo,adat
		banksel	valtozo
		movlw	adat & H'FF'
		movwf	valtozo
		movlw	adat >>D'8' & H'FF'
		movwf	valtozo+1
		movlw	adat >>D'16' & H'FF'
		movwf	valtozo+2
		movlw	adat >>D'24' & H'FF'
		movwf	valtozo+3
		endm
;***************************************************	
; LET16 - 16-bites eljel nlkli rtkads
;  valtozo: az eljel nlkli vltoz cme
;     adat: a vltozba rand adat (0 - 0xffff)
;
; Plda: 
;		LET16	my_word,D'57360'
;***************************************************
LET16	macro	valtozo,adat
		banksel	valtozo
		movlw	adat & H'FF'
		movwf	valtozo
		movlw	adat >>D'8' & H'FF'
		movwf	valtozo+1
		endm

;***************************************************	
; LET8 - 8-bites eljel nlkli rtkads
;  valtozo: az eljel nlkli vltoz cme
;     adat: a vltozba rand adat (0 - 0xff)
;
; Plda: 
;		LET8	my_byte,D'160'
;***************************************************
LET8	macro	valtozo,adat
		banksel	valtozo
		movlw	adat 
		movwf	valtozo
		endm

PGM      CODE
;--- A fprogram ktelezen a main cmknl kezddik!
main:	LET32	my_dword,D'573612400'
		JOBBRA_LEP32 my_dword,2			;my_dword = my_dword >> 2
		LET16	my_word,D'13572'
		JOBBRA_LEP16	my_word,4		;my_word = my_word >> 4
		LET8	my_byte,D'37'
		JOBBRA_LEP8	my_byte,3			;my_byte = my_byte >> 3
		goto $
		end