/* PICCOLO project
 * Copyright (c) 2009 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include <delays.h>

/** \file
Ledvillogtat program, amelyben a LED fnyerejt impulzusszlessg modulcival vltoztatjuk.
A program LED4-et villogtatja, amely PIC18F14k50 esetn az RC3, PIC18F4550 esetn pedig
az RD3 kivezetsre csatlakozik

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya

*/

unsigned char i;

void main(void) {
    LEDtris=0xf0;                 //LEDport<3:0> legyen kimenet
    LEDport=0;                    //kezdetben a LED-ek legyenek kikapcsolva
    while (1) {
        for (i=1; i<100; i++) {
            LEDport=0x08;         //LED4 bekapcsolsa
            Delay1KTCYx(i);       //i-vel arnyos idej ksleltets
            LEDport = 0;          //LED4 kikapcsolsa
            Delay1KTCYx(150-i);   //Kiegszt idej ksleltets
        }
        for (i=1; i<100; i++) {
            LEDport=0x08;         //LED4 bekapcsolsa
            Delay1KTCYx(100-i);   //i-vel arnyosan cskken idzts
            LEDport = 0;          //LED4 kikapcsolsa
            Delay1KTCYx(i+50);    //kiegszt idej ksleltets
        }
    }
}
