/* PICCOLO project
 * Copyright (c) 2009 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include "stdio.h"

/** \file
Mintaprogram a mikrovezrl tpusazonost (DEVID2/DEVID1) s felhasznli
azonost (USERID) kiolvassra.

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
   - USB kapcsolat
*/

unsigned char ch,ct,cd1,cd2,i;

/** Egy eljel nlkli bjtot ktjegy hexadecimlis formban kir
 * a kimeneti bufferbe. Ez a fggvny meghvja a blokkol tpus
 *  _user_putc() fggvnyt! 
 */ 
void out2hex(unsigned char t) {
	unsigned char c;
		c=(char)((t>>4) & 0x0F);
		if (c>9) c+=7;
		_user_putc(c+'0');
		c=(char)(t & 0x0F);
		if (c>9) c+=7;
		_user_putc(c+'0');
}

void main(void) {
    InitializeSystem();
    //-- kivrjuk az els karakter berkezst
    while (!usb_cdc_kbhit()) {
        ProcessIO();
    }
    outString("read_id.c program on ");
	#if defined(__18F4550)
    	outString("PICCOLO-4550\n");
	#elif defined(__18F14K50)
		outString("PICCOLO-14K50\n");
	#endif
	TBLPTR= (unsigned short long)0x3ffffe;	//DEVID cme
		_asm tblrdpostinc _endasm
	cd1=TABLAT;
		_asm tblrdpostinc _endasm
	cd2=TABLAT;
	outString("Device ID = ");
	out2hex(cd2); 
	out2hex(cd1); 
	outString("   User ID = ");
	TBLPTR= (unsigned short long)0x200000;	//UserID cme
	for(i=0; i<8; i++) {
		_asm tblrdpostinc _endasm
		ct=TABLAT;
		out2hex(ct);
	}
	outString("\n");
    while (1) {
        ch=usb_cdc_getc();
        usb_cdc_putc(ch);
    }
}


