/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include "delays.h"

char c;

/** \file
 *  Pldaprogram az alvs zemmdbl az INT0 interruptal trtn bresztsre.
 *  Az INT0 bemeneten lefut lre bekvetkez programmegszaktst engedlyezzk. 
 *  A CPU megszaktst azonban letiltva hagyjuk, gy az interrupt krelem nem 
 *  okoz megszaktst, csupn bresztst vgez.
 * 
 *  Hardver kvetelmnyek: az "A ksrleti ramkr" cm fejezetben bemutatott referencia 
 *  ramkrt ki kell egszteni: az INT0 bemenet s VSS kz egy nyomgombot (SW3), 
 *  az INT0 bemenet s VDD kz pedig egy 10 kohmos felhzellenllst kell ktni.
 *  PIC18F4550 esetn a bels felhzst is bekapcsoltuk, gy a kls felhzs elhagyhat.
 *
 *  Projekt konfigurci: Csak a HID_BOOTLOADER szimblumot definiljuk 
 */

 ///Az INT0 bemenet inicializlsa
void initINT0(void) {
	#if defined(__18F4550)
		ADCON1 = 7;				//B port minden lba legyen digitlis
		TRISB=0xFF;				//B port minden lba legyen bemenet
		INTCON2bits.RBPU=0;		//legyen B port minden lba felhzva (ne lebegjen)	
	#elif defined(__18F14K50)
		ANSELbits.ANS4=0;		//RC0 legyen digitlis bemenet	
	#endif
		INTCON2bits.INTEDG0=0;	//INT0 negatv lre legyen rzkeny
		INTCONbits.INT0IF=0;	//az INT0 interrupt jelzbitjnek trlse
		INTCONbits.INT0IE=1;	//az INT0 interrupt engedlyezse	
}

/** Ksleltet eljrs, amely a Microchip PIC18 knyvtri eljrsait hasznlja.
 * A bels ciklus kb. 1 ms ksleltetst vgez. 
 * \param d az elrt vrakozsi id, 1 ms egysgekben
 */ 
void delay_ms(unsigned int d) {
unsigned int j;
	for(j=0; j<d; j++) {
		Delay1KTCYx(12);		//12 000 TCY ksleltets (~ 1ms)
	}
}

//-- A fprogram -------------------------------------------
void main(void) {
unsigned int i;
	LEDport=0;					//LEDport inicializlsa
	LEDtris=0xF7;				//Csak LED4 legyen kimenet, a tbbi bemenet
	RCONbits.IPEN=1;			//Ktszint megszaktsi md belltsa
	INTCONbits.GIE=0;			//Minden interrupt letiltsa
	initINT0();					//INT0 inicializlsa

	while (1) {
		for(i=0; i<20; i++) { 
	    	delay_ms(250);		//villogtatshoz ksleltets
			mLED_4_Toggle();	//LED4 llapotvlts
		}
		INTCONbits.INT0IF=0;	//trljk az interrupt jelzbitet
		LEDport &= 0xF0;		//Lehunyja ngy szemt a LEDport
		Sleep();				//a j CPU is aluszik...
		Nop();					//lmban mg prefetch-csel egy kicsit...
   }
}

