
/**
 * \page Examples PIC18 Mintaprogramok
 *
 * Ezen az oldalon a 
 * <a href="http://esca.atomki.hu/PIC18">"PICCOLO projekt: Ismerkeds a PIC18 mikrovezrlkkel"</a> 
 * cm honlapon tallhat mintaprogramokat mutatjuk be.
 *
  *<strong>Megjegyzs:</strong>  Az els fejezetek mintapldit, amelyeket kifejezetten szimultorban trtn kiprblsra szntunk, itt nem
 * dokumentltuk, mivel a zmben assembly nyelv programokat a Doxygen nem dolgozza fel rendesen(az assembly nyelvet nem tmogatja).
 * Ezeket a programokat, illetve projekteket is megtalljuk azonban a 
 * <a href="http://esca.atomki.hu/PIC18/code_examples.zip">letlthet programgyjtemnyben</a>, 
 * s itt is megtekinthetk, a <a href="files.html">Flj menpontra</a> kattintva.
 *
 * \section usingExamples A mintaprogramok hasznlata
 *
 * Elszr \ref gettingStarted "Az els lpsek" cm tmutatt nzze t, s gyzdjn meg rla, hogy a szksges 
 * hardver s szoftver eszkzk jl vannak belltva, s mkdkpesek. 
 *
 * A kibontott PIC18 pldaprogramokat brhov teleptheti, a mintaprogramok projektjei csak relatv elrsi tvonalakat hasznlnak. 
 * Az MPLAB miatt rdemes azonban rvid elrsi tvonalat vlasztani, s ne legyen benne sem szkz, sem kezetes bet!
 * A programok fejlesztse eredetileg a C:\\PIC18 knyvtrban trtnt.
 *
 * Minden projekt egy mdostott linker llomnyt is tartalmaz, amire a betlt program (bootloader) miatt van szksg.
 * Ha a programokat bootloder nlkl, kzvetlenl egy programoz  kszlkkel (pl. PICkit2)
 * akarjuk begetni, akkor az MPLINK program opcii kzl ki kell venni a bootloader defincijt (
 * Project men Build options -> Project pontjban az MPLINK lapon vegye ki a pipt az "Use Alternate Settings" ell!)
 * s a piccolo_config.h llomnyban tegynk komment jelet a bootloader definci (#define HID_BOOTLOADER) el!
 *
 * Mieltt lefordtannk a programot, gyzdjnk meg rla, hogy <b>Release</b> (kiads) s nem <b>Debug</b> 
 * (nyomkvetshez val) vltozatot fordtunk! A Debug belltssal fordtott programok hardveres nyomkvet csatlakoztatsa nlkl 
 * nem fognak helyesen mkdni a ksrleti ramkrnkn...
 
 * Legclszerbb taln a ksrleti ramkr lesztst a ch08/ledflash.c programmal kezdeni.
 *
 * \section exampleDirectory A pldaprogramok jegyzke
 *<b>A ksrleti ramkr fellesztse</b>
 * - ch08/ledflash_a.asm LED4 villogtatsa assembly programmal
 * - ch08/ledflash.c   Ledvillogtat program, amelyben az sszes LED-et egyszerre villogtatjuk
 * - ch08/ledflash2.c Ledvillogtat program, amelyben kt-kt LED-et ellentemben villogtatunk.
 * - ch08/ledflash3.c Ledvillogtat program, amelyben a LED fnyerejt impulzusszlessg modulcival vltoztatjuk.
 * - ch08/knight.c "Knight Rider" jelleg ledvillogtat program.
 *
 *<b>USB</b> (az USB CDC kapcsolat hasznlata) 
 * - usb/hello-poll.c Az USB hasznlata lekrdezses (polling) mdban
 * - usb/hello-int.c Az USB hasznlata programmegszaktsos (interrupt) mdban
 * - usb/cdc-demo.c Egyszer parancsrtelmez az USB interaktv hasznlatnak bemutatsra
 * - usb/daq-int.c "Adatgyjt" program, a nem blokkol tpus ksleltets bemutatsa
 *  
 * <b>Az I/O portok hasznlata</b>
 * - ioports/ledswitch.c LED ki/bekapcsolsa nyomgombbal
 * - ioports/ledswitch2.c LED ki/bekapcsolsa nyomgombbal (vges llapotgp mdszer)
 * - ioports/switches.c LED vezrlse nyomgombbal s kapcsolval (vges llapotgp mdszer)
 * - ioports/reset.c A lehetsges RESET tpusokkal ksrletez mintaprogram
 *
 *<b>Programmegszaktsok</b>
 * - ch09/change_test.c A vltozsjelz interrupt hasznlata egy nyomgomb lenyomsainak figyelsre.
 * - ch09/bounce_test.c Nyomgomb pergsnek vizsglata
 * - ch09/wakeup.c A CPU felbresztse vltozsjelz programmegszaktssal
 * - ch09/wakeup-int0.c A CPU felbresztse az INT0 programmegszaktssal
 * - ch09/wakeup-int2.c Mintaprogram INT2 hasznlatra
 *  
 * <b>Idztk/szmllk</b>
 * - timers/squarewave.c Ngyszghullm ellltsa Timer2-vel keltett periodikus programmegszaktsok segtsgvel
 * - timers/ledblink.c LED4 villogtatsa, Timer0-vel keltett periodikus  programmegszaktsok segtsgvel
 * - timers/ledswitch_tmr0.c  Bemenet mintavtelezse Timer0 megszaktsokkal, LED1 ki/bekapcsolsa 
 * - timers/rtc.c Timer1 kls oszcilltornak hasznlata (Real Time Clock)
 *
 * <b>Analg perifrik</b>   
 * - analog/adc-14k50.c Ksrletezs az ADC, FVR s DAC/CVref konfigurlsval (csak PIC18F14K50-hez!!!)
 * - analog/thermometer-14k50.c Feszltsg s hmrsklet mrse (csak PIC18F14K50-hez!!!) 
 * - analog/thermometer2-14k50.c Feszltsg s hmrsklet mrse tlagolssal ( csak PIC18F14K50-hez!!!) 
 * - analog/ledek.c Analg jellel trtn vezrls (futfny)
 * - analog/adclib.c Feszltsg s hmrsklet mrse a Microchip tmogati programknyvtr hasznlatval
 *
 * <b>LCD alfanumerikus kijelz hasznlata</b>
 * - lcd/lcd_8bit.c LCD alfanumerikus kijelz hasznlata, 8 bites mdban
 * - lcd/lcd_4bit.c LCD alfanumerikus kijelz hasznlata, 4 bites mdban 
 * - lcd/lcd4_kodtabla.c LCD karaktertbla megjelentse, sajt karakterek definilsa (4 bites md)
 * - lcd/xlcd_8bit.c LCD kijelz hasznlata a gyri fggvnyekkel (8 bites md)
 *
 * <b>I2C soros I/O</b>   
 * - i2c/lm75_i2c.c I2C kommunikci az LM75A digitlis hmrvel
 * - i2c/2xlm75_i2c.c Kt hmr kezelse az I2C buszon
 * - i2c/24lc515_i2c.c Microchip 24LC515 tpus I2C EEPROM rsa s olvassa
 *
 * <b>SPI soros I/O</b>   
 * - spi/25lc256_spi.c 25LC256 tpus EEPROM rsa s olvassa 
 * - spi/mcp23s17_spi.c Az MCP23S17 16 bites perifriabvt egyszer hasznlata
 * 
 * \section coming_soon Elkszletben:
 * <b>Aszinkron soros I/O</b>   
 */
