// Documentation placed on the Changelog page. This file only
// include comments for Doxygen; it does not contain any
// code.
/**
 * \page C18lib A Microchip C18 v3.22 PIC18 perifriaknyvtr javtsai, mdostsai, hasznlata
 *
 * \section xlcd A PIC18 perifriaknyvtr jrafordtsa   (2010-11-18)
 * A C18 fejleszti krnyzethez tartoz PIC18 perifriaknyvtrban az LCD kezelsre szolgl fggvnyekbe "bele van drtozva",
 * hogy az LCD vezrlshez melyik portot, s hogy 4 vagy 8 bites mdban hasznlja adattknt, s hogy mely portlbakat hasznlja vezrlsre (RS, R/W, E).
 * Az xlcd fggvnyek hasznlathoz teht nagy valsznsggel mdostani kell az <b>xlcd.h</b> llomnyt s jra kell fordtani 
 * az adott mikrovezrlhz taroz perifriaknyvtrat (pl. a p18F14K50.lib llomnyt). 
 *
 * <b>Felttelezett kiindulsi helyzet:</b>  teleptett MPLAB 8.15a s Microchip C18 v3.22 fordt (utbbi a C:\\Program Files\\Microchip\\MCC18 mappban).
 * -#  Ksztsnk munkaterletet a C:\\MCC18 mappban, s msoljuk bele a C18 teleptsi mappa \\h s \\src mappjt (utbbit az alknyvtrak tartalmval egytt)!
 * -#  Hozzunk ltre egy res C:\\MCC18\\lib mappt is! (Ebbe kerlnek majd a fordts sorn ltrejv programknyvtrak)
 * -#  Mdostsuk a C:\\MCC18\\h mappban az xlcd.h llomnyt! Pldul 8 bites mdhoz, adatport = PORTC s RS=RB5, RW=RB6, E=RB7 esetn az llomny elejn
 *       a hardverspecifikus defincikat  az albbiak szerint rjuk t:
\code
 /* Interface type 8-bit or 4-bit
 * For 8-bit operation uncomment the #define BIT8
 */
#define BIT8

/* When in 4-bit interface define if the data is in the upper
 * or lower nibble.  For lower nibble, comment the #define UPPER
 */
#define UPPER   //Ennek most nincs jelentsge

/* DATA_PORT defines the port to which the LCD data lines are connected */
#define DATA_PORT      PORTC
#define TRIS_DATA_PORT TRISC

/* CTRL_PORT defines the port where the control lines are connected.
 * These are just samples, change to match your application.
 */
#define RS_PIN   LATBbits.LATB5      /* PORT for RS */ 
#define TRIS_RS  TRISBbits.TRISB5    /* TRIS for RS */ 
#define RW_PIN   LATBbits.LATB6      /* PORT for RW */ 
#define TRIS_RW  TRISBbits.TRISB6    /* TRIS for RW */ 
#define E_PIN    LATBbits.LATB7      /* PORT for E  */ 
#define TRIS_E   TRISBbits.TRISB7    /* TRIS for E  */
\endcode
* -#  Ellenrizzk, hogy az albbi programok elrhetk s parancssorbl mkdkpesek:
*    -  MPLAB C18 (mcc18.exe)
*    -  MPASM assembler (mpasm.exe)
*    -  MPLIB librarian (mplib.exe)
* -#  lltsuk be az elrsi tvonalat az include direktvkhoz:
*    \code
*       SET MCC_INCLUDE=C:\MCC18\h
*    \endcode
* -#  A C:\\MCC18\\src knyvtrban adjuk ki az albbi parancsot:
*    \code
*       make_one_device_t.bat 18F14K50
*    \endcode 
* -# Az alkalmazsok fordtsnl gyeljnk arra, hogy az ltalunk mdostott xlcd.h llomnyt
*    s az C:\\MCC18\\lib mappban megjelen j knyvtr(aka)t csatoljuk a projekt-hez!
*    Legegyszerbb, ha biztonsgi msolatot ksztnk a rgi llomnyokrl s bemsoljuk 
*    a helykre az j <b>xlcd.h</b> s <b>p18f4520.lib</b> llomnyokat.
*
* <b>Megjegyzs:</b> Az OpenXLCD() fggvny paramterezse azt sejteti, hogy futskor 
* vlaszthatunk a 4 vagy 8 bites zemmd kztt. Ez, sajnos, nem gy van, mivel a 
* perifriaknyvtr fordtsakor a forrskdban elhelyezett feltteles fordtsi direktvk 
* miatt eleve csak egyfle zemmd vezrl parancsai fordulnak le, s utlagos mdosts
* csak jrafordtssal lehetsges. 
* gy teht az OpenXLCD() fggvny paramterezsnl mr csak a 
* hibs vagy a hibtlan belts kztt vlaszthatunk (hibtlan a bellts akkor, amikor 
* a megadott zemmd megegyezik azzal, amire a programknyvtrat fordtottuk). 
*
*<b>Egy mintaplda az LCD kezelsre a "gyri" perifriaknyvtr felhasznlsval</b>
* 
* Az albbi mintaprogramban 8 bites adatttal, ktsoros mdban inicializljuk az LCD modult, 
* az 5x7-es fontmret hasznlva. Mindkt sorba kirunk egy-egy rvid szveget.
*
*<b>Hardver kvetelmnyek:</b> 
*   - PICCOLO projekt alapkapcsols, PIC18F14K50 mikrovezrlvel
*   - 2x16 karakteres LCD kijelz. Az adatvonalak a LEDport-ra legyenek ktve, a vezrl vonalak 
*     pedig a B portra (E = RB7, R/W = RB6, RS = RB5) 
*
*<b>Projekt konfigurci:</b>
*   - Csak a HID_BOOTLOADER szimblumot definiljuk (az USB kapcsolatot s a programmegszaktst
*     most nem hasznljuk.
*   - Ha mg nem trtnt meg, akkor a fentebb ismertetett mdon konfigurljuk az xlcd.h llomnyt 
*     s lefordtjuk a PIC18F14K50 mikrovezrl perifriaknyvtrt.
*   - Az MPLAB Project/Build Options/Project menben az Include Search Path s Library Search 
*     Path belltsnl gyelnk arra, hogy az jonnan lefordtott programknyvtrat, s az ltalunk
*     mdostott xlcd.h llomnyt "tallja meg" a fordt! (A mdostott xlcd.h llomnyt tneveztk
*     piccolo-xlcd.h nvre, s a PICCOLO projekt include mappjban kapott helyet). 
\code
#include "piccolo_all.h"
#include "piccolo_xlcd.h"
#include "delays.h"
 
void DelayFor18TCY(void) {
   Delay10TCYx(2);          //20 TCY delay
}
          
void DelayPORXLCD(void) {
   Delay10KTCYx(60);         //50 ms delay
}
         
void DelayXLCD() {
   Delay1KTCYx(60);          //5 ms delay
}
         
const rom char szoveg[]= "PICCOLO projekt";
         
void main(void) {   
   DISABLE_ALL_ANALOG();
   OpenXLCD( EIGHT_BIT & LINES_5X7 );
   while( BusyXLCD() );
   putrsXLCD(szoveg);        //els sor kirsa
   while( BusyXLCD() );
   SetDDRamAddr(0xC0);       //kurzor a msodik sor elejre
   while( BusyXLCD() );      //msodik sor kirsa
   putrsXLCD("PIC18F14K50 MCU");
   while(1);   
} 
\endcode 
*
* \section adc_if Az adc.h llomny javtsa I.   (2010-08-05)

* A 3.22-es verzij C18 fordtval kapott  <b>adc.h</b> header fjlban nincsenek definilva 
* az ADC_V10 kategrij (PIC13K50, PIC14K50) mikrovezrlkhz  az <b>OpenADC()</b> 
* paramterezshez szksges makrk egy rsze (pl. a konverzis rajelet s az adatgyjtsi 
* idt konfigurl makrk).
* 
* Javtsa: a fjl elejn az els hossz 
 \code
   #if defined ( ADC_V1 ) || defined ( ADC_V2 ) ... stb. 
 \endcode  
*    litniba vegyk fel  a <b>|| defined(ADC_V10)</b> tagot is!
*
* \section andmasks Az adc.h llomny javtsa II.  (2010-08-05)
* Az ADC_V10 kategrij (PIC13K50, PIC14K50) mikrovezrlknl hibs nhny AND tpus maszk defincija. Helyesen gy nznek ki:
 \code
	#define ADC_REF_VDD_VDD  0b11110011 // ADC voltage source VREF+ = AVDD
	#define ADC_REF_VDD_VREFPLUS  0b11110111 // ADC voltage source VREF+ = ext. source at VREF+
	#define ADC_REF_VDD_FVREF         0b11111011 // ADC voltage source VREF+ = FVREF+
 \endcode
* Eredetileg hibsan, egy helyirtkkel jobbra csszva vannak definilva!
*
* \section enable_anx Az adc.h llomny kiegsztse  (2010-08-05)
*<b>ENABLE_AN3....ENABLE_AN11 makrk definilsa a piccolo-14k50.h llomnyban</b>
*
* A <b>PIC18F14K50</b> analg csatorni egymstl fggetlenl engedlyezhetk. 
* Ehhez nincs j gyri makr, ezrt definiltam nhnyat az OpenADC() fggvny negyedik 
* paramternek (az ANSEL s ANSELH registerekbe rand rtk) knyelmes sszelltshoz. 
 \code
	#define ENABLE_AN3  0x0008
	#define ENABLE_AN4  0x0010
	#define ENABLE_AN5  0x0020
	#define ENABLE_AN6  0x0040
	#define ENABLE_AN7  0x0080
	#define ENABLE_AN8  0x0100
	#define ENABLE_AN9  0x0200
	#define ENABLE_AN10 0x0400
	#define ENABLE_AN11 0x0800
 \endcode
 * Ezeket a makrkat az <b>OpenADC()</b> fggvny utols paramternek (PORTCONFIG)
 * sszelltshoz hasznlhatjuk. Pldul az albbi kdrszletben az AN10 s AN11 csatornkat engedlyezzk: 
 \code
  #include "adc.h"
  #define USE_OR_MASKS
  OpenADC(ADC_FOSC_64 | ADC_RIGHT_JUST | ADC_20_TAD,
	ADC_CH10 | ADC_INT_OFF,
	ADC_REF_VDD_VDD | ADC_REF_VDD_VSS,
	ENABLE_AN10 | ENABLE_AN11);  
 \endcode
 */
