/* PICCOLO project
 * Copyright (c) 2010-2011 Istvan Cserny (cserny@atomki.hu)
 *
 */
#include "piccolo_all.h"
#include "piccolo_i2c.h"

/** \file
 * I2C plda: Az I2C tmogati fggvnyek hasznlatt egy 
 * NXP gyrtmny, LM75A tpus digitlis hmr 
 * konfigurlsa s kiolvassa kapcsn mutatjuk be. A fokokban kirt hmrsklet
 * mellett a nyers kiolvasott adatot is megjelentjk (hexadecimlisan).
 * 
 * Hardver igny:
 * - PICCOLO projekt ksrleti ramkr, melyet egy LM75A (vagy ms, vele
 *   kompatibilis tpus I2C hmrvel) kell kiegszteni, s az I2C busz vonalait 
 *   egy-egy 2-10 kohmos ellenllssal fel kell hzni. 
 * - Az eredmnyek megjelentshez az USB kapcsolatot is hasznljuk.
 */ 

//-- Projekt konfigurci ellenrzse 
#if defined(USE_INTERRUPT) 
	#error "Nem kell definilni az USE__INTERRUPT szimblumot!"
#endif //USE_INTERRUPT
#if !defined(USE_USB)
	#error "Nincs definilva az USE_USB szimblum!"
#endif //USE_USB


/** Az LM75A digitlis hmr CONFIG regiszternek belltsa.
 * \param addr a hmr egyedi I2C cme.
 */
void LM75_init(uint8 addr) { 	
  i2c_start();						//j tranzakcit kezdnk
  i2c_putc(addr & 0xFE);			//Slave cm s write md
  i2c_putc(0x01);					//A vezrlregiszter cme
  i2c_putc(0x18);					//Konfigurci belltsa (FT=6,normal mode)
  i2c_stop();						//A tranzakci vge		
}

/** Az LM75A digitlis hmr TEMP regiszternek kiolvassa.
 *  A visszatrsi rtk 16 bites, eljeles szm, melyben a 
 *  11 bites adat balra igaztott. Kiolvass eltt belltjuk a regisztermutatt.
 *  \param addr a hmr egyedi I2C cme.
 */
int LM75_readTemp(uint8 addr) {
union16 temp;
  i2c_start();
  i2c_putc(addr & 0xFE);			//Slave cm s rs md	
  i2c_putc(0x00);					//A TEMP regiszter cme
  i2c_rstart();						//RESTART a mdvltshoz
  i2c_putc(addr | 0x01);			//Slave cm s olvass md
  temp.hi_byte=i2c_getc(I2C_ACK);	//egy bjt fogadsa nyugtzssal (fokok olvassa)
  temp.lo_byte=i2c_getc(I2C_NAK);	//utols bjt olvassa negatv nyugtzssal (trtrsz olvassa)
  i2c_stop();						//tranzakci vge	
  return ((int16)temp.word);
}

void main(void) {
int16 temp;
int32 tmp32; 
  InitializeSystem();
  while (!usb_cdc_kbhit()) {
    ProcessIO();
  }
  i2c_init(100);                    //100 kHz-es I2C bitrta 
  LM75_init(0x90);                  //a hmr belltsa 
  outString("\nIsten hozott a PICCOLO projekthez!\n");
  outString("LM75_i2c.c program, MCU: ");
#if defined(__18F4550)
  outString("PIC18F4550\n");
#elif defined(__18F14K50)
  outString("PIC18F14K50\n");
#endif
    while (1) {
      delay_ms(2000);
      temp=LM75_readTemp(0x90);     //a hmr kiolvassa
      outString("T1 = ");
      tmp32=(temp*10L+128L)/256;    //tizedfokokra szmtjuk t, kerektssel
      outdec(tmp32,1);              //Kirats egy tizedesre
      outString(" C (0x");
      out4hex((uint16)temp);        //Nyers adat hexadcimlis kirsa
      outString(")\n");
   }
}