/* PICCOLO project
 * Copyright (c) 2009-2011 Istvan Cserny (cserny@atomki.hu)
 */
 
/** \file
 *  Ez a header llomny deklarlja az I2C tmogati fggvnyeket s a hasznlatukhoz szksges makrkat
 */  
#ifndef PICCOLO_I2C_H
#define PICCOLO_I2C_H

#define I2C_ACK		0	//pozitv nyugtzs
#define I2C_NAK		1	//negatv nyugtzs

/* Makrk az SSPCON1 regiszter belltshoz  */
#define   SSPENB    			0b00100000  	/* Enable serial port and configures SCK, SDO, SDI*/
#define   SLAVE_7   			0b00000110     	/* I2C Slave mode, 7-bit address*/
#define   SLAVE_10  			0b00000111    	/* I2C Slave mode, 10-bit address*/
#define   MASTER    			0b00001000     	/* I2C Master mode */
#define   MASTER_FIRMW			0b00001011		//I2C Firmware Controlled Master mode (slave Idle)
#define   SLAVE_7_STSP_INT 		0b00001110		//I2C Slave mode, 7-bit address with Start and Stop bit interrupts enabled
#define   SLAVE_10_STSP_INT 	0b00001111		//I2C Slave mode, 10-bit address with Start and Stop bit interrupts enabled

/* Makrk az SSPSTAT regiszter belltshoz */
#define   SLEW_ON   			0b00000000  	/* Slew rate vezrls engedlyezve (400kHz md) */
#define   SLEW_OFF  			0b10000000  	/* Slew rate vezrls letiltva  (100kHz md) */
#define   SMBUS_ENABLE 			0b01000000  	/* SMBUS specifikus bemenet engedlyezse */
#define   SMBUS_DISABLE			0b00000000  	/* SMBUS specifikus bemenet tiltsa  */

#define i2c_idle()  while ((SSPCON2 & 0x1F) | (SSPSTATbits.R_W))

#define i2c_start() SSPCON2bits.SEN=1; while(SSPCON2bits.SEN)

#define i2c_rstart() SSPCON2bits.RSEN=1; while(SSPCON2bits.RSEN)

#define i2c_stop()  SSPCON2bits.PEN=1; while(SSPCON2bits.PEN)

#define i2c_ack(ackbit)   SSPCON2bits.ACKDT=ackbit; SSPCON2bits.ACKEN=1; while(SSPCON2bits.ACKEN)


void i2c_init(uint16 bitrate_kHz);
uint8 i2c_getc(uint8 ack2send);
uint8 i2c_putc(uint8 data);
void i2c_write1(uint8 addr,uint8 data);
void i2c_write2(uint8 addr,uint8 d1, uint8 d2);
void i2c_writeN(uint8 addr, uint8* data, uint8 cnt);
void i2c_read1(uint8 addr,uint8* p1);
void i2c_read2(uint8 addr,uint8* p1, uint8* p2);
void i2c_readN(uint8 addr,uint8* p1, uint8 cnt);
#endif




