/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"

/** \file
A lehetsges RESET tpusokkal ksrletez mintaprogram, amely 
USB kapcsolaton keresztl kommunikl a felhasznlval. 
A felhasznl vlasztstl fggn kiprblhatja a RESET utastst,
a Watchdog timeout-ot, valamint a SLEEP utastst, s felledskor
a program kirja az jrainduls okt. A szndkos jraindts mellett
a Power-On Reset s a Brown-out Reset bekvetkeztt jelz biteket is
figyeljk s kijelezzk.  

Ebben a programban USB kapcsolatot interruptos mdban kezeljk, ezrt a
program lefordtshoz az USE_USB szimblumon kvl az USE_INTERRUPT 
szimblumot is definiltuk.

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
   - USB kapcsolat
*/

unsigned char c;

/*** INTERRUPT KISZOLGL ELJRSOK **********************************/
#if defined(USE_INTERRUPT)
	///Magas priorits programmegszakts kiszolglsa
	#pragma interrupt hi_isr
	void hi_isr() {
	#if defined(USB_INTERRUPT)
	    USBDeviceTasks(); //--- USB programmegszakts kiszolglsa
	#endif  //USB_INTERRUPT
	}
	///Alacsony priorits programmegszakts kiszolglsa
	#pragma interruptlow lo_isr
	void lo_isr() {
	}
#endif //USE_INTERRUPT

void main(void) {
    InitializeSystem();
    //-- kivrjuk az els karakter berkezst
    while (!usb_cdc_kbhit()) {
        ProcessIO();
    }
    outString("\n\n");
	//-- megnzzk, hogy milyen RESET trtnt
	if(RCONbits.RI==0) {
		RCONbits.RI=1;			//Programbl kell trlni
		outString("Reset utasts volt\n");
	}
	if(RCONbits.TO==0) {		//csak CLRWDT trli!
		WDTCONbits.SWDTEN=0;	//Watchdog tiltsa
		outString("WDT time-out trtnt\n");
	}
	if(RCONbits.PD==0) {		//csak CLRWDT trli!
		outString("Power-down (Sleep) trtnt\n");
	}
	if(RCONbits.POR==0) {
		RCONbits.POR=1;			//Programbl kell trlni
		outString("Power-on-Reset trtnt\n");
	}
	if(RCONbits.BOR==0) {
		RCONbits.BOR=1;			//Programbl kell trlni
		outString("Brown-out Reset trtnt\n");
	}
	ClrWdt();					//Alaphelyzetbe lltja TO s PD biteket
	#if defined(__18F4550)
		outString("PICCOLO-4550");
	#elif defined(__18F14K50)
		outString("PICCOLO-14K50");
	#endif
    outString(" - reset.c program\n");
    outString("Vlasszon az albbi lehetsgek kzl!\n");
    outString("1 - Watchdog bekapcsolsa\n");
    outString("2 - Sleep zemmd bekapcsolsa\n");
    outString("3 - WDT & Sleep engedlyezse\n");
    outString("4 - Reset utasts vgrehajtsa\n");
	outString("Melyiket vlasztja? ");
    while (1) {
        c=usb_cdc_getc();
		usb_cdc_putc(c);
        switch (c) {
		case '1':    
			delay_ms(1000);
			WDTCONbits.SWDTEN=1;
		break; 
		case '2':
			delay_ms(2000);
			Sleep();
		break;
		case '3':
			delay_ms(1000);
			WDTCONbits.SWDTEN=1;
			Sleep();
		break;
		case '4':
			delay_ms(2000);
			Reset();
		break;
		default:
		break;
		} //switch
    } //while
}
