/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include  <stdio.h>  
#include  <delays.h>

/** \file
Az ipari szabvnynak tekinthet prhuzamos illesztvel elltott 2x16 karakateres 
LCD kijelz hasznlatt mutatja be, 4 bites mdban, printf hasznlattal. 
A fprogramban a kijelzre kt hossz sort kirunk, majd a kijelzt vgtelen 
ciklusban eggyel balra lptetjuk. Az LCD modul bels felptsnek ksznheten 
a szveg automatikusan "krbefordul": amikor 40 karaktert kilptettnk, jra a 
sor eleji karakterek jelennek meg a kijelzn, jobbrl beszva.


Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
   - 2x16 karakteres LCD kijelz (bekts: RS=LED1, RW=LED2, E=LED3, D7..D4=LEDport
     magasabb helyirtk fele)

*/

//-- A hardverfgg rszletek elklntse
#define RSHIGH()         LEDport |= 0x01;
#define RSLOW()          LEDport &= 0xFE;
#define RWHIGH()         LEDport |= 0x02;
#define RWLOW()          LEDport &= 0xFD;
#define EHIGH()          LEDport |= 0x04;
#define ELOW()           LEDport &= 0xFB;
#if defined(__18F14K50)
   #define BUSY_FLAG PORTCbits.RC7;
#elif  defined(__18F4550)
   #define BUSY_FLAG PORTDbits.RD7;
#endif 
#define DATA_DIR_RD()    LEDtris = 0xF0;
#define DATA_DIR_WR()    LEDtris = 0x00;
#define OUTPUT_DATA(x)  {LEDport = (LEDport & 0x0F) | x;}

//-- Az E vezrljel pulzlsa 
void epulse(void){
    Delay10TCYx(2);  
    EHIGH();  Delay10TCYx(2); 
    ELOW(); Delay10TCYx(1);
}

//-- Egy bjt (parancs vagy adat) kirsa
void lcd_write(unsigned char cmd, 
               unsigned char data_flag, 
               unsigned char chk_busy, 
               unsigned char dflag){
char bflag,c;
  if (chk_busy) {
    RSLOW();                 //RS = 0 a foglaltsg figyelshez
    DATA_DIR_RD();           //adatvonalak vtelre lltsa
    RWHIGH();                //R/W = 1 olvasshoz
    do {
      EHIGH(); 
      Delay10TCYx(2);
      bflag = BUSY_FLAG;     //fels 4 bit olvassa
      ELOW(); Delay10TCYx(2);
      epulse();              //als flbjt kilptetse
    } while(bflag);
  } else {
    Delay10KTCYx(12);        //Foglaltsg figyels helyett ksleltets
  }
  DATA_DIR_WR();             //Adatvonalak rsra lltsa
  if (data_flag) { 
    RSHIGH();                //RS=1, ha adatklds kvetkezik
  }
  else RSLOW();              //RS=0, ha parancsot kldnk
  RWLOW();                   //R/W = 0, rshoz
  c = cmd & 0xF0;            //fels 4 bit kirsa
  OUTPUT_DATA(c);
  epulse();
  if (dflag) {
    c = (cmd & 0x0F)<<4;     //als 4 bit kirsa
    OUTPUT_DATA(c);
    epulse();
  }
}
    
//-- Az LCD modul inicializlsa
void lcd_init(void) {
//-- Az LCD-t vezrl vonalak inicializlsa
  DATA_DIR_WR();
  ELOW();
  RSLOW();
  RWLOW(); 
//-- Az LCD modul szoftveres reset-else s inicializlsa
  Delay10KTCYx(60);          //50 ms vrakozs az LCD felledsre 
  lcd_write(0x30,0,0,0);     //8 bites zemmd      
  Delay10KTCYx(6);           //5 ms vrakozs
  lcd_write(0x30,0,0,0);     // 4 bites zemmd
  lcd_write(0x30,0,0,0);     // 8 bites zemmd
  lcd_write(0x20,0,0,0);     // 4 bites zemmdba kapcsolunk
//-- Innen kezdve a 4 bites zemmd l (kldsnl dflag=1 kell)
  lcd_write(0x28,0,0,1);     // 2 soros display, 5x7 font
//-- Innen kezdve figyelhet a BF jelzbit (chk_busy=1)
  lcd_write(0x08,0,1,1);     // display letilts
  lcd_write(0x01,0,1,1);     // kpernytrls
  lcd_write(0x0C,0,1,1);     // display be, cursor, s villogs ki
  stdout = _H_USER;          // a felhasznli fggvny legyen a
                             // standard kimenet, ami az LCD-re r
}

//-- karakterkir fggvny, amit a stdio.h-ban deklarlt kimeneti
//-- fggvnyek (putc, puts, fprintf, printf) meghvhatnak.
void _user_putc (auto char c) {   
    lcd_write(c,1,1,1);
}

void main(void){
  DISABLE_ALL_ANALOG();      //Minden analg bemenet tiltsa
//-- Az LCD modul inicializlsa
  lcd_init ();
  printf(" Isten hozott a PICCOLO projekthez! ");
  lcd_write(0xC0,0,1,1);     //Kurzor mozgatsa a msodik sor elejre
#if defined(__18F14K50)
	printf(" PIC18F14K50 MCU, lcd_4bit.c program");
#else
	printf(" PIC18F4550 MCU, lcd_4bit.c program ");
#endif
  while(1) {
      Delay10KTCYx(120);
      Delay10KTCYx(120);
      Delay10KTCYx(120);
      lcd_write(0x18,0,1,1); //Balra lptetjk a megjelentett szveget
   }
}