/* PICCOLO project
 * Copyright (c) 2009-2011 Istvan Cserny (cserny@atomki.hu)
 */
#include "piccolo_all.h"
#include "piccolo_spi.h"
#include "delays.h"


/** \file
 * SPI mintaprogram: az MCP23S17 16 bites perifriabvt egyszer hasznlatt mutatja be:
 *   - az A porton minden bitet egyszerre villogtatunk 2 Hz frekvencival.
 *   - a B porton ellentemben vltogatjuk a bitek llapott 1 Hz frekvencival.
 *
 * Hardver kvetelmnyek: a ksrleti ramkrt egy MCP23S17 perifriabvtvel  kell
 * kiegszteni, az sszektst az albbi tblzat szerint alaktsuk ki:
 *  \code
 *  PIC18 14K50 4550                  MCP23S17
 *  ===========================================
 *  SDI   RB4   RB0 <----------------- SO  (14)
 *  SDO   RC7   RC7 -----------------> SI  (13)
 *  SCK   RB6   RB1 -----------------> SCK (12)
 *  LED4  RC3   RD3 -- Slave Select -> CS  (11)
 *  VDD   ---------------------------- VCC (9), RESET(18)
 *  GND   ---------------------------- GND (10), A0,A1,A2 (15,16,17)
 * \endcode
 *
 * Projekt konfigurci: sem az USB kapcsolatot, sem a programmegszaktst nem hasznljuk! 
 */

#define MCP23S17ADDR 0x40   //MCP23S17 cme, ha mindegyik cmvezrl lb fldre van ktve
#define IODIRA_CIME 0x00    //Az A port adatramlsi irnyt bellt regiszter cme
#define IODIRB_CIME 0x01    //A  B port adatramlsi irnyt bellt regiszter cme
#define OLATA_CIME  0x14    //Az A port kimen adatregiszternek cme
#define OLATB_CIME  0x15    //A  B port kimen adatregiszternek cme

//-- Slave Select kimenet definilsa
#define SLAVE_ENABLE()     mLED_4 = 0          //Slave kivlasztsa
#define SLAVE_DISABLE()    mLED_4 = 1          //Slave eszkz letiltsa

//-- Az MCP23S17 egy regiszternek rsa
#define MCP23S17_write(reg,data) {SLAVE_ENABLE(); \
                           spi_io(MCP23S17ADDR); \
                           spi_io(reg); \
                           spi_io(data); \
                           SLAVE_DISABLE(); }

/** Ksleltet eljrs, amely a Microchip PIC18 knyvtri eljrsait hasznlja.
 * A bels ciklus kb. 1 ms ksleltetst vgez. 
 * \param d az elrt vrakozsi id, 1 ms egysgekben
 */
void delay_ms(unsigned int d) {
unsigned int i;
	for(i=0; i<d; i++) {
		Delay1KTCYx(12);		//12 000 TCY ksleltets (~ 1ms)
	}
}

void main (void) {
uint8 a_dat=0,b_dat=0x55; 
  DISABLE_ALL_ANALOG();
  mInitAllLEDs();
  SLAVE_DISABLE();
//-- Az SPI1 modul konfigurlsa 3 MHz-es, Mode_00 master mdba.
  spi_init(CKP_ACTIVE_HIGH |                //aktv llapotban az rajel magas szint
           MASTER_FOSC_16,                  //SPI rajel FOSC/16 (3 MHz)
           SPI_CKE_ON |                     //kimenet aktv/inaktv tmenetkor (CKE=1)
           SPI_SMP_END);                    //A bemenetet az adatkimeneti id vgn mintavtelezzk
  MCP23S17_write(IODIRA_CIME,0);            //Az A port minden bitje legyen kimenet
  MCP23S17_write(IODIRB_CIME,0);            //Az A port minden bitje legyen kimenet
  MCP23S17_write(OLATA_CIME,a_dat);         //Az A port kimeneti adatregiszternek belltsa
  MCP23S17_write(OLATB_CIME,b_dat);         //A B port kimeneti adatregiszternek belltsa
  while (1) {
    a_dat = ~a_dat;                         //komplementljuk a kimen adatokat
    b_dat = ~b_dat;
    mLED_1_Toggle();                        //LED1 llapotvltsa az A port rst jelzi 
    mLED_2_Toggle();                        //LED2 llapotvltsa a B port rst jelzi 
    MCP23S17_write(OLATA_CIME,a_dat);       //Az A port jrarsa
    MCP23S17_write(OLATB_CIME,b_dat);       //A B port jrarsa
    delay_ms(250);
    a_dat = ~a_dat;
    mLED_1_Toggle();                        //LED1 llapotvltsa az A port rst jelzi 
    MCP23S17_write(OLATA_CIME,a_dat);       //Az A port jrarsa
    delay_ms(250);
  }
}
