/* PICCOLO project
 * Copyright (c) 2009-2011 Istvan Cserny (cserny@atomki.hu)
 */
#include "piccolo_all.h"
#include "piccolo_spi.h"
#include "delays.h"
#include "timers.h"


/** \file
 * SPI mintaprogram: az MCP23017 16 bites perifriabvt egyszer hasznlatt mutatja be:
 *   - az A porton minden bitet egyszerre villogtatunk 2 Hz frekvencival.
 *   - a B porton ellentemben vltogatjuk a bitek llapott 1 Hz frekvencival.
 *
 * Hardver kvetelmnyek: a ksrleti ramkrt egy 25LC256 SPI EEPROM-mal kell
 * kiegszteni, az sszektst az albbi tblzat szerint alaktsuk ki:
 *  \code
 *  PIC18 14K50 4550                  MCP23S17
 *  ===========================================
 *  SDI   RB4   RB0 <----------------- SO  (14)
 *  SDO   RC7   RC7 -----------------> SI  (13)
 *  SCK   RB6   RB1 -----------------> SCK (12)
 *  LED4  RC3   RD3 -- Slave Select -> CS  (11)
 *  VDD   ---------------------------- VCC (9), RESET(18)
 *  GND   ---------------------------- GND (10), A0,A1,A2 (15,16,17)
 * \endcode
 *
 * Projekt konfigurci: sem az USB kapcsolatot, sem a programmegszktst nem hasznljuk! 
 */

#define MCP23017ADDR 0x40   //MCP23017 cme, ha mindegyik cmvezrl lb fldre van ktve


//-- Slave Select kimenet definilsa
#define SLAVE_ENABLE()     mLED_4 = 0       //Slave kivlasztsa
#define SLAVE_DISABLE()    mLED_4 = 1       //Slave eszkz letiltsa

#define spi_write3(a,b,c) {SLAVE_ENABLE(); \
                           spi_io(a); \
                           spi_io(b); \
                           spi_io(c); \
                           SLAVE_DISABLE(); }
/** Ksleltet eljrs, amely a Microchip PIC18 knyvtri eljrsait hasznlja.
 * A bels ciklus kb. 1 ms ksleltetst vgez. 
 * \param d az elrt vrakozsi id, 1 ms egysgekben
 */
void delay_ms(unsigned int d) {
unsigned int i;
	for(i=0; i<d; i++) {
		Delay1KTCYx(12);		//12 000 TCY ksleltets (~ 1ms)
	}
}

void main (void) {
uint8 a_dat=0xF0,b_dat=0x55; 
  DISABLE_ALL_ANALOG();
  mInitAllLEDs();
  LEDport = 0x0F;
  SLAVE_DISABLE();
  TRISBbits.TRISB7=0;
  PR2 = 4;                                  //peridus regiszter belltsa (5 - 1)
  OpenTimer2(TIMER_INT_OFF | T2_PS_1_1 | T2_POST_1_11 );

//-- Az SPI1 modul konfigurlsa 3 MHz-es, Mode_00 master mdba.
  spi_init(CKP_ACTIVE_HIGH |                //aktv llapotban az rajel magas szint
           MASTER_TMR2,                     //SPI rajel FOSC/16 (3 MHz)
           SPI_CKE_ON |                     //kimenet aktv/inaktv tmenetkor (CKE=1)
           SPI_SMP_END);                    //A bemenetet az adatkimeneti id vgn mintavtelezzk
  while (1) {
    spi_write3(MCP23017ADDR,a_dat,b_dat);  
	Delay100TCYx(12);
    LATBbits.LATB7=~LATBbits.LATB7;
  }
}
