/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#define USE_OR_MASKS			//timers.h-ben "VAGY" mvelettel egyesthet makrk legyenek
#include "timers.h"				//gyri makrk s fggvnyek az idztkhz  
#include "delays.h"				//gyri fggvnyek a ksleltetshez

/** \file
*  LED4 villogtatsa, Timer0-vel keltett periodikus 
*  programmegszakts segtsgvel. A villogs temt az SW1 nyomgombbal ngy
*  fokozatban llthatjuk.
*
*  Hardver kvetelmnyek: a program az "A ksrleti ramkr" cm fejezetben bemutatott referencia 
*  ramkrkn fut, az ramkr kiegsztsre/bvtsre nincs szksg.
*
*  Projekt konfigurci: A program mkdshez a HID_BOOTLOADER szimblumon kvl  
*  az USE_INTERRPT szimblumot is definilni kell. Az USB kapcsolatot nem hasznljuk.
*/

#pragma interrupt hi_isr		//Timer0 megszakts kiszolglsa
void hi_isr(void) {
	mLED_4_Toggle()				//tbillenti LED4 llapott 
	INTCONbits.TMR0IF = 0;		//trli az interrupt jelzbitet
}

#pragma interruptlow lo_isr
void lo_isr() {
}

/** Ksleltet eljrs, amely a Microchip PIC18 knyvtri eljrsait hasznlja.
 * A bels ciklus kb. 1 ms ksleltetst vgez. 
 * \param d az elrt vrakozsi id, 1 ms egysgekben
 */
void delay_ms(unsigned int d) {
unsigned int i;
	for(i=0; i<d; i++) {
		Delay1KTCYx(12);		//12 000 TCY ksleltets (~ 1ms)
	}
}

void main (void) {
unsigned char fokozat=0;		//0=1:32, 1=1:64, 2=1:128, 3=1:256
unsigned char ps[]={T0_PS_1_32, T0_PS_1_64, T0_PS_1_128,T0_PS_1_256};
	mInitAllLEDs();
	mInitSwitch1();
//-- Timer0 konfigurlsa LED4 interrupton trtn villogtatshoz
	INTCON2bits.TMR0IP=1;		//Timer0 megszakts magas priorits legyen
	OpenTimer0(TIMER_INT_ON 
				| T0_16BIT 
				| T0_SOURCE_INT 
				| T0_PS_1_32 );
	RCONbits.IPEN=1;			//Ktszint megszaktsi md belltsa
	INTCONbits.GIEH=1;			//A magas priorits interrupt engedlyezse
	INTCONbits.GIEL=0;			//Az alacsony priorits interrupt tiltsa
//-- A fprogramban csak az elosztt kapcsolgatjuk,
//-- az interrupt elvgzi a tbbi munkt
	while (1) {
		while(SW1==1);			//lenyomsra vr
    	delay_ms(20);			//pergsmentest ksleltets
		if(fokozat==3) {
			fokozat = 0;		// 1:32 osztsi arny visszalltsa
		} else {
			fokozat++;			//nveli az elosztsi arnyt
		}
		T0CON=(T0CON & T0_PS_MASK) | ps[fokozat];	//tllta az elosztt
		ChangeBits(LEDport,fokozat,0x03);			//LEDport als kt bitjn
													//kijelzi a fokozatot
		while(SW1==0);			//felengedsre vr
    	delay_ms(20);			//pergsmentest ksleltets
  	}
}
