/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"

/** \file
Mintaprogram, az USB kapcsolat interaktv hasznlatnak bemutatsra.
A program egy egyszer parancsrtelmezt tartalmaz, amely a virtulis
soros portrl kapott egybets parancsokat rtelmezi s vgrehajtja.

Minden parancsot a #-jellel kezdjk, s a parancs betjelvel folytatjuk.
A D parancsot egy ktjegy hexadecimlis szmnak kell kvetnie.
Az rtelmezett parancsok:
 - #A - analg jel mrse (a potmter llsa)
 - #B - nyomgomb llapotnak lekrdezse
 - #Dnn - LEDport belltsa
 - #H - help kiirsa
 - #L - LED villogtats tilts/engedlyezs
 - #V - verzi s CPU azonost kiratsa

Ha a program lefordtsa eltt az USE_USB s az USE_INTERRUPT szimblumokat
is definiljuk, akkor az USB kapcsolat kiszolglsa interrupt szinten
trtnik. Ha csak az USE_USB szimblumot definiljuk, akkor pedig lekrdezses
zemmdban trtnik a kezels,ugyangy, mint a hello-poll.c programnl.

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
   - USB kapcsolat
*/


/*** VLTOZK ********************************************************/
unsigned int adat;
char uc,uv;

/*** INTERRUPT KISZOLGL ELJRSOK **********************************/
#if defined(USE_INTERRUPT)
	///Magas priorits programmegszakts kiszolglsa
	#pragma interrupt hi_isr
	void hi_isr() {
	#if defined(USB_INTERRUPT)
	    USBDeviceTasks(); //--- USB programmegszakts kiszolglsa
	#endif  //USB_INTERRUPT
	}
	///Alacsony priorits programmegszakts kiszolglsa
	#pragma interruptlow lo_isr
	void lo_isr() {
	}
#endif //USE_INTERRUPT

/*********************************************************************
 *    FPROGRAM:  USB CDC demo                                       *
 *********************************************************************/
void main(void) {
    InitializeSystem();
//-- Megvrjuk az els karakter rkezst
    while (!usb_cdc_kbhit()) {
        ProcessIO();
    }
    outString("Isten hozott a PICCOLO projekthez!\n");
    outString("cdc-demo.c program (USB CDC demo)\n");
    while (1) {
//--- j parancsra vrunk. A parancs #-jellel kezddik
        do {
            uv=usb_cdc_getc();
        } while (uv!='#');
        uc=usb_cdc_getc();
        usb_cdc_putc(uv);
        usb_cdc_putc(uc);
        switch (uc) {
        case 'A':    //Analg feszltsg mrse (potmter)
            adat=ReadPOT();
            out4hex(adat);
            break;
        case 'B':    //SW1 llapotnak kirsa
            if (SW1) {
                usb_cdc_putc('1');       //felengedve
            } else {
                usb_cdc_putc('0');       //lenyomva
            }
            break;
        case 'D':    //LEDport belltsa
            adat=get2hex();
            LEDport=adat;
            break;
        case 'H':    //Help kirsa
            outString("elp:\n");
            outString("#A - analog jel merese\n");
            outString("#B - nyomogomb allapota\n");
            outString("#Dnn - LEDport beirasa\n");
            outString("#H - help kiirasa\n");
            outString("#L - LED villogtatas tiltas/engedelyezes\n");
            outString("#V - verzio es CPU azonosito kiiratasa\n");
            break;
        case 'L':    //LED villogs tilts/engedlyezs
            BlinkUSBStatus_enabled=!BlinkUSBStatus_enabled;
            if (BlinkUSBStatus_enabled) {
                usb_cdc_putc('1');
            } else {
                usb_cdc_putc('0');
            }
            break;
        case 'V':                        //Verzi s CPU kirsa
            outString("er 1.0 CDC-demo on ");
			#if defined(__18F4550)
            	outString("PICCOLO-4550");
			#elif defined(__18F14K50)
            	outString("PICCOLO-14K50");
			#endif
            break;
        default:
            usb_cdc_putc('?');          //Ismeretlen parancs
            break;
        } //switch
        usb_cdc_putc(0x0D);             //Kocsi vissza (CR)
        usb_cdc_putc(0x0A);             //Soremels (LF)
    } //while
}     //main
/******** Fprogram vge *********************************************/
