;------------------------------------------------------
; PICCOLO project
; Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
;
; Mintaprogram a 32 bites szmok osztshoz definilt makrk 
; hasznlatnak bemutatsra
;
; FIGYELEM: A programot az MPLAB szimultorban futtassuk! 
;------------------------------------------------------
#include "..\include\p18_all.inc"

;******************************************************
; Helyfoglals a vltozk szmra
; Az az albbi makrkkal vgzett osztsokhoz ktelezen 
; az ACCESS terleten kell elhelyeznnk az adatokat! 
;****************************************************** 
mydata	UDATA_ACS 
pOPA	RES 4
pOPB	RES 4
pRES	RES 4
pCYC	RES 1

;***************************************************	
; 32-bites eljel nlkli szm osztsa 8-bites
; eljel nlkli szmmal
;  dividend:  a 32 bites osztand cme
;   divisor:  a 8 bites osztand cme
;       rem:  a 8 bites maradk cme
; pCYC:  a ciklusvltoznak hasznlt egybjtos vltoz
; ennek fixen foglaljunk helyet valahol
; A makr felttelezi, hogy minden vltoz az ACCESS
; blokkban van!
;***************************************************
UDIV32_8	macro	dividend,divisor,rem
		local	UD8LOOP,UD8SUB,UD8NOSUB
		movlw	D'32'
		movwf	pCYC
		clrf	rem
		bcf		STATUS,C
UD8LOOP:
		rlcf	dividend
		rlcf	dividend+1
		rlcf	dividend+2
		rlcf	dividend+3
		rlcf	rem
		bc		UD8SUB
		movf	divisor,W
		subwf	rem,W
		bnc		UD8NOSUB
UD8SUB:
		movf	divisor,W
		subwf	rem
		incf	dividend
UD8NOSUB:
		decfsz	pCYC
		bra		UD8LOOP
		endm

;***************************************************	
; 32-bites eljel nlkli szm osztsa 16-bites
; eljel nlkli szmmal
;  dividend:  a 32 bites osztand cme
;   divisor:  a 16 bites osztand cme
;       rem:  a 16 bites maradk cme
; pCYC:  a ciklusvltoznak hasznlt egybjtos vltoz
; ennek fixen foglaljunk helyet valahol
; A makr felttelezi, hogy minden vltoz az ACCESS
; blokkban van!
;***************************************************
UDIV32_16	macro	dividend,divisor,rem
		local 	UD16LOOP,UD16SUB,UD16NOSUB
		movlw	D'32'
		movwf	pCYC
		clrf	rem
		clrf	rem+1
		bcf		STATUS,C
UD16LOOP:
		rlcf	dividend
		rlcf	dividend+1
		rlcf	dividend+2
		rlcf	dividend+3
		rlcf	rem
		rlcf	rem+1
		bc		UD16SUB
		movf	divisor,W
		subwf	rem,W
		movf	divisor+1,W
		subwfb	rem+1,W
		bnc		UD16NOSUB
UD16SUB:
		movf	divisor,W
		subwf	rem
		movf	divisor+1,W
		subwfb	rem+1
		incf	dividend
UD16NOSUB:
		decfsz	pCYC
		bra		UD16LOOP
		endm

;***************************************************	
; 32-bites eljel nlkli szmok osztsa
;  dividend:  a 32 bites osztand cme
;   divisor:  a 32 bites osztand cme
;       rem:  a 32 bites maradk cme
; pCYC:  a ciklusvltoznak hasznlt egybjtos vltoz
; ennek fixen foglaljunk helyet valahol
; A makr felttelezi,hogy minden vltoz az ACCESS
; blokkban van!
;***************************************************
UDIV32_32	macro	dividend,divisor,rem
		local UD32LOOP,UD32NOSUB
		movlw	D'32'
		movwf	pCYC
		clrf	rem
		clrf	rem+1
		clrf	rem+2
		clrf	rem+3
		bcf		STATUS,C
UD32LOOP:
		rlcf	dividend
		rlcf	dividend+1
		rlcf	dividend+2
		rlcf	dividend+3
		rlcf	rem
		rlcf	rem+1
		rlcf	rem+2
		rlcf	rem+3
		movf	divisor,W
		subwf	rem,W
		movf	divisor+1,W
		subwfb	rem+1,W
		movf	divisor+2,W
		subwfb	rem+2,W
		movf	divisor+3,W
		subwfb	rem+3,W
		bnc		UD32NOSUB
		movf	divisor,W
		subwf	rem
		movf	divisor+1,W
		subwfb	rem+1
		movf	divisor+2,W
		subwfb	rem+2
		movf	divisor+3,W
		subwfb	rem+3
		incf	dividend
UD32NOSUB:
		decfsz	pCYC
		bra		UD32LOOP
		endm

;***************************************************	
; LET32 - 32-bites eljel nlkli rtkads
;  valtozo: az eljel nlkli vltoz cme
;     adat: a vltozba rand adat (0 - 0xffffffff)
;
; Plda: 
;		LET32	my_dword,D'573612400'
;***************************************************
LET32	macro	valtozo,adat
		banksel	valtozo
		movlw	adat & H'FF'
		movwf	valtozo
		movlw	adat >>D'8' & H'FF'
		movwf	valtozo+1
		movlw	adat >>D'16' & H'FF'
		movwf	valtozo+2
		movlw	adat >>D'24' & H'FF'
		movwf	valtozo+3
		endm
;***************************************************	
; LET16 - 16-bites eljel nlkli rtkads
;  valtozo: az eljel nlkli vltoz cme
;     adat: a vltozba rand adat (0 - 0xffff)
;
; Plda: 
;		LET16	my_word,D'57360'
;***************************************************
LET16	macro	valtozo,adat
		banksel	valtozo
		movlw	adat & H'FF'
		movwf	valtozo
		movlw	adat >>D'8' & H'FF'
		movwf	valtozo+1
		endm

;***************************************************	
; LET8 - 8-bites eljel nlkli rtkads
;  valtozo: az eljel nlkli vltoz cme
;     adat: a vltozba rand adat (0 - 0xff)
;
; Plda: 
;		LET8	my_byte,D'160'
;***************************************************
LET8	macro	valtozo,adat
		banksel	valtozo
		movlw	adat 
		movwf	valtozo
		endm

PGM      CODE
;--- A fprogram ktelezen a main cmknl kezddik!
main:	LET32 pOPA,H'553175FF'
		LET8 pOPB,H'FD'
		UDIV32_8 pOPA,pOPB,pRES
		nop						;hnyados = 0x563412, maradk = 0x35
		LET32 pOPA,H'C3785557'
		LET16 pOPB,H'ABCD'
		UDIV32_16 pOPA,pOPB,pRES
		nop						;hnyados = 0x12345, maradk = 0x16
		LET32 pOPA,H'14B60416'
		LET32 pOPB,H'12345'
		UDIV32_32 pOPA,pOPB,pRES
		nop						;hnyados = 0x1234, maradk = 0x12
		goto $
		end