/* PICCOLO project
 * Copyright (c) 2009 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include <delays.h>

/** \file
Ledvillogtat program, amelyben Knight Rider mdra psztzzuk a fnycsvt
A program felvltva villogtatja LED1..LED4-et , amelyek PIC18F14k50 esetn az RC3..RC0,
PIC18F4550 esetn pedig az RD3..RD0 kivezetsekre csatlakoznak

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya

*/

const char a[]={0x01,0x03,0x07,0x06,0x0E,0x0C,0x08,0x0C,0x0E,0x06,0x07,0x03};
char i,j;
void main(void) {
    LEDport=0;             //Kezdetben LEDport minden bitje '0' legyen
    LEDtris=0;             //LEDport minden bitje legyen kimenet
#if defined(__18F14K50)
    while (SW1) {
#else
    while (1) {
#endif
        for (LEDport=j=0; j<12; j++) {
            LEDport = 0x01;
            Delay10KTCYx(5);
            LEDport = 0;
            Delay10KTCYx(80);
        }
        for (i=j=0; j<44; j++) {
            LEDport=a[i];
            Delay10KTCYx(60);     //2 560 000 TCY ksleltets
            i++;
            if (i>11) i=0;
        }

    }
    Reset();
}
