/**
 * \page gettingStarted Az els lpsek
 * A PIC18 pldaprogramok hasznlathoz el kell ksztenie a ksrleti eszkzket:
 * -# \ref softwareInstall - Teleptse a szksges szoftvereket egy Windows alap szemlyei szmtgpre!
 * -# \ref hardwareBringup - ptsen vagy vsroljon PIC18 ksrleti ramkrt!
 * -# \ref pic18Test -- Hasznlja a letltprogramot, tltse le a "ledflash" programot a PIC18 mikrovezrlbe s prbalja ki vele a ksrleti ramkrt! 
* Ezzel ellenrizheti a teleptett szoftver s a hardver mkdkpessgt. Az albbiakban rszletesebb tmutatst tall a fenti lpsek elvgzshez.  
 *
 *
 * \section softwareInstall Szoftverek teleptse
 * -# Tltse le a Microchip honlapjrl s teleptse az  
 *    <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en019469&part=SW007002">MPLAB IDE</a> programcsomagot. A teljes vltozat 
 *    telept csomagjt (Full Release Zipped) kell kivlasztani a "Letltsek" szakaszban, kzel a lap aljhoz.
 *     A v8.1x-es vltozat esetben a kvetkez gombokra kell kattintani a telepts folyamn: 
 *     next, next, I accept/next, next, next, next, next, yes, finish.
 * -# Tltse le a Microchip honlapjrl s teleptse az 
 *    <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en010065"> Microchip
 *    PIC18 mikrovezrlkhz val C18 fordtjt!</a>. <br />Megjegyzs:
 *    -# Elszr az MPLAB csomagot kell telepten, csak utna szabad telepteni a C18 fordtt.
 *    -# A C fordt teleptse sorn mindentt fogadja el a felajnlott opcit, a teleptsi knyvtrat kivve. (
           Szerintem logikusabb az MPLAB teleptsi knyvtrba telepteni a C18 fordtt, mint a C: gykrknyvtrba...) Klnsen fontos, 
 *       hogy a "Yes" gombra kattintson a  krnyezeti vltozk mdostsa ( "Modify Environment?") krdsnl!
 *     A C fordt teleptsvel nem jelenikmeg jabb program a Windows Start menjben, csupn az MPLAB integrlt 
 *   fejleszti krnyezetben vlik elrhetv a C18 fordt.
 * -# Tltse le a Microchip honlapjrl s teleptse az <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=2680&dDocName=en537044">FSUSB keretrendszert</a> (
 a  Microchip Application Libraries nev zip llomnyt kell letlteni, a letltsi link az USB Framework c. lap aljn tallhat). 
 Ebben szmos mintaplda mellett az ltalunk hasznlt HID bootloaderek s a HID Bootloder letltprogram is megtallhatk az USB-Device-Bootloaders mappban. 
 * -# Ha nincs a szmtgpn teleptve a Microsoft .NET keretrendszer, akkor tltse le s teleptse
 *     a .NET futtatrendszert a
 *     <a href="http://www.microsoft.com/downloads"> Microsoft Letlt Kzpont</a> honlapon a
 *	  '.NET runtime' kifejezsre keresve! A 2.0-t vagy ksbbi verzit teleptse! 
 *	  Ha nem biztos abban, hogy teleptve van-e a gpn a .NET keretrendszer, akkor indtsa el a kvetkez lpsben
 * ismertetett letltprogramot,  s ha az hibt jelez, akkor teleptse a .NET keretrendszert. 
 * -# Tltse le s teleptse a PICCOLO projekt PIC18 pldaprogramjainak gyjtemnyt a szmtgpre (nagyon ajnljuk, hogy az elrsi tvonal
 *    ne tartalmazzon szkzt vagy kezetes karaktereket, s legyen rvid  ( legalkalmasabb a C:\\PIC18 knyvtr). 
     A legfrissebb vltozat <a href="http://esca.atomki.hu/PIC18/code_examples.zip"> ITT tallhat </a>.
 * -# Prblja ki a letltprogramot, ami egy .NET alkalmazs, a bootloader\HIDBootLoader.exe program elindtsval! 
 *    Egy grafikus kezeli felletnek kell megjelennie. 
 *
 * \section hardwareBringup A hardver fellesztse
 * Tbbfle lehetsg van a PIC18 pldaprogramok futtatshoz szksges PIC18 ksrleti ramkr beszerzsre: 
 * - \ref Wireup "Huzalozza ssze egy prbapanelen" valamelyik ltalunk ajnlott <a href="http://esca.atomki.hu/PIC18/circuit.html">ksrleti ramkrt</a>! 
 * - Ha rendelkezik PICkit2 Starter Kit kis lbszm (PIC16F690) demkrtyval, akkor talalkthatja azt a PIC18F14K50 mikrovezrl 
 *    hasznlathoz a <a href="http://esca.atomki.hu/PIC18/usb-uart.html">ezt az tmutatt kvetve</a>
 * - Vsrolhat kszen egy \ref LPCUSB "LPC USB demkrtyt."
 * - Vsrolhat kszen egy \ref FSUSB "Microchip PICDEM FS-USB demkrtyt."
 *
 * \section Wireup A PIC18 ksrleti ramkr sszehuzalozsa
 * -# Az <a href="http://esca.atomki.hu/PIC18/usb-uart.html">USB-UART talakt</a> c. tmutat, vagy egyni elkpzelse alapjn lltsa ssze
 *      a <a href="http://esca.atomki.hu/PIC18/circuit.html">Ksrleti ramkr</a> c. fejezetben ajnlott valamelyik mintaramkrt!
 * -# Ha nem sikerlt elre begetett bootloaderrel elltott mikrovezrlt beszereznie, akkor \ref ICSP "ICSP programoz" felhasznlssal gesse be 
 *a HID betlt programot (bootloader-t) a PIC18 mikrovezrlbe!
 *
 * \section LPC USB Microchip Low Pin Count USB fejlesztkszlet
 * -# Vsroljon egy <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en536385"> Kis Lbszm USB fejleszti krtyt</a> 
 *    (a PICKit2-tel kiegsztett DV164126 kit-et ajnljuk, mivel gy kedvez ron jutunk egy
 *    sokoldalan hasznlhatprogramoz kszlkhez, amellyel harveres nyomkvetst is vgezhetnk).
 * -# A PICkit2 felhasznlsval a <a href="http://esca.atomki.hu/PIC18/circuit.html">Ksrleti ramkr</a> c. fejezetben lert tmutatt kvetve
 *      gessk be a  bootloader/HID_Bootloader_PIC18F14K50.hex llomnyt.
 *
 * \section FSUSB PICDEM FSUSB demkrtya
 * A PICDEM FSUSB egy fejleszti krtya a Microchiptl, ami a PIC18F4550 mikrovezrlhz kszlt. A krtya gyrilag begetett bootoader programmal
 * kerl forgalomba. Ehhez a krtyhoz azonban a Microchip egyedi betltprogramot ksztett, amirl a kvetkezket kell tudnunk:
 *     - Ez a bootloader az USB keretrendszerben tallhat PDFSUSB.exe programmal hasznland  (ami demprogram s letltprogram egyben).
 *     - Els csatlakoztatskor teleptennk kell az MHCPUSB Custom Driver meghajtprogramot ( az USB keretrendszer USB Tools/MHCPUSB Custom 
 *        Driver mappban keressk)
 *     - Az MHCPUSB bootloader kisebb mret, mint a HID bootloader, ezrt msik linker llomnyt kell hasznlni hozz
 *        (lsd a <a href="http://esca.atomki.hu/PIC18/circuit.html">Ksrleti ramkr</a> c. fejezet vgn tallhat sszefoglal tblzatokban!)
 *
 * \section ICSP ICSP programoz kszlkek
 * Ha olyan PIC18 mikrovezrlt vsrol, amelyik nincs felprogramozva a betltprogrammal, akkor  nnek kell gondoskodnia a betltprogram begetsrl, 
 * s csak utna tudja (a begetett betlt program segtsgvel) letlteni a futtatni kvnt programokat. Ha esetleg a betltprogram megsrl, 
 * akkor pedig jra be kell getni azt a mikrovezrlbe. Egy halad felhasznl gy is dnthet, hogy kitrli a betltprogramot, s a PIC18 mikrovezrlbe egy ICSP
 * programoz kszlkkel tlti be a kiprblni kvnt programokat. Az ICSP az angol In Circuit Serial Programming elnevezs rvidtse, ami azt jelenti, 
 * hogy magban a ksrleti ramkrben trtnik a mikrovezrl programozsa, mghozz soros kommunikcival - csak egy adatvonal (PGD)  s 
 * egy szinkron rajel bemenet (PGC) kell hozz.
 * Szmos lehetsg kzl vlaszthatunk:
 *   - A Microchip <a href="http://www.microchip.com/pickit2"> PICkit2 </a> programozja 
 *     kedvez ron kaphat; csak magra a PICkit2 kszlkre van szksgnk, nem pedig a klnfle "starter kit"-ekre! (kivve termszetesen azt az esetet, 
 *     ha a mintaprogramokat az LPC USB development kit-en akarja kiprblni...)
*      A PICkit2 kszlk a programozson kvl hardveres nyomkvetsre, logikai analiztorknt s soros (UART) kommunikcis eszzknt is hasznlhat. 
 *   - Egy msik, valamivel kltsgesebb eszkz a Microchip <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en010046&part=DV164005">ICD2</a> 
 *     programoz s hardveres nyomkvet eszkze.
 *   - Esetleg ms gyrtk termke is hasznlhat, de vsrls eltt gyzdjnkmeg rla, hogy a kszlk kompatibilis az ltalunk hasznlni kvnt  mikrovezrlvel s 
 *     az MPLAB fejleszti krnyezettel. Ugyanezt tancsoljuk az Interneten kering kapcsolsi rajzok alapjn utngyrtott ICD2 s PICkit2 klnokkalkapcsolatban is. 
 *     Klnsen arra kell gyelni, hogy a PIC18F14K50 PGD s PGC lbaira ne kerljn 3,6 V-nl nagyobb feszltsg!
 *
 * A betltprogram begetse PICkit2-vel a PIC mikrovezrlbe: 
 *   -# Tltse le s teleptse a <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en023805"> PICkit 2 szoftvert </a> a Microchip honlapjrl!
 *   -# Csatlakoztassa a PICkit2 kszlket a ksrleti ramkrhez (vagy demkrtyjhoz)!
 *      A PICkit2 kszlken a nyl az 1. lbat jelzi.
 *      - Lehetsges, hogya PICkit2 firmware-t frisstenie kell. Ha a PICkit kezelprogramja ezt jelzi, akkor 
 *        kattintson a Tools -> Download PICkit 2 Operating System menpontra.
 *   -# A PICkit2 kezelprogramjban vlassza ki a Device Family menben a PIC18 csaldot!
 *      - Ha a PIC18 mikrovezrlt nem ismeri fel automatikusan a PICkit2 kszlk, akkor nyomja le a RESET gombot a ksrleti ramkrben. 
 * Miutn felengedte a RESET gombot, kattintson a  Read gombra a kezelprogramban!
 *      - Ellenrizze, hogy a mikrovezrlt felismerte a PICkit2 kszlk!
 *      - Kattintson az Erase (trls) gombra s trlje vele a mikrovezrl memrijt!
 *      - A betltprogram begetni val hex llomnyai a code/bootloader knyvtrban tallhatk.
 *         Tltse be a megfelel hex llomnyt a File -> Import Hex menpont kivlasztsval. Gyzdjn meg rla, hogy az 
 *         adott mikrovezrlhz val llomnyt vlasztotta! 
 *
 * \section pic18Test Az ramkr kiprblsa a ledflash programmal
 * A szksges szoftver s hardver eszkzkkel, felszerelkezve prblja ki rendszert az egyszer 'ledflash.c' program lefordtsval s letltsvel! 
 * A ledflash.c program  egyszerre villogtatja az sszes LED-et. 
 * A kiprblshoz:
 *  -# Mieltt a  PIC18 mikrovezrl programozshoz kezdennk, gyzdjnk meg rla, hogy minden szksges szoftver teleptve van,
 * s a  mikrovezrlbe is be van getve a betltprogram (lsd az elz lpseket). 
 *  -# Indtsa el az MPLAB programot, majd nyissa meg a \ref ledflash.c program projektjt az MPLAB Project -> Open menpontjban! Ne lepdjn meg, 
 * ha az llomnyok nem jelennnek meg a projekt ablakban, mivel a letlthet progamknyvtr nem
 * tartalmaz elmenetett "munkaterlet" (workspace) llomnyokat. Ha nem ltszik a Project ablak, akkor nyissa meg azt a View menben! Hasonlan nyissa meg
 * (ha nem ltszana)  az Output ablakot is!
 *  -# A projekt gy ahogy van, PIC18F14K50 mikrovezrl esetn le kell, hogy forduljon; a fordts a Project -> Make menpont kivlasztsval 
 *      (vagy az F10 gomb megnyomsval)  indthat. Ha mgsem fordul le, akkor az albbiakat ellenrizze:
 *     -# Kattintson a Configure -> Select Device (Konfigurls -> Eszkz kivlasztsa) menpontra s gyzdjn meg rla, hogy a megfelel 
 *           mikrovezrl tpus (esetnkben PIC18F14K50) van kivlasztva!
 *     -# Ellenrizze a \ref piccolo_config.h llomnyt, s lltsa be a szksges opcikat! A \ref ledflash.c program lefordtshoz csak a
 *          bootloaderre vonatkoz sornak (pl. #define HID_BOOTLOADER) szabad aktvnak lennie, a USE_USB s USE_INTERRUPT sorok
 *         maradjanak kommentben!
 *     -# Vlassza ki a Project -> Build Options -> Project menpontot (Projekt -> Fordtsi opcik -> Projekt). A Directories (Knyvtrak) fln a, 
 *          "Show directories for:" (mutassa a knyvtrakat) listn ellenrizze az Include Search Path (include fljok elrsi tvonala)  belltsait 
 *          s gyzdjn meg rla, hogy azok megegyeznek  az n gpn lev MPLAB s C18 programknyvtr teleptssl. 
 *          (Az ..\\include s a C:\\Program Files\\Microchip\\MCC18\\h tvonalakat adtuk meg,
 *          melyek kzl az els a piccolo_all.h llomny elrshez, a msik a "gyri" header llomnyok elrsi tvonala.)
 *         Azt is ellenrizze, hogy az MPLINK opciinl (a Project men Build options ->  Project pontjban, az MPLINK
 *         lap kivlasztsa utn) , hogy helyes van-e balltva a bootloader tpusa (/uHID_BOOTLOADER).
 * -#  Ha PIC18F4550 mikrovezrlre akarja lefordtani a projektet, akkor kattintson a Configure -> Select Device (
 *       Konfigurls -> Eszkz kivlasztsa) menpontra, s vlassza ki a PIC18F4550 mikrovezrlt! Tvoltsa el a Projektbl a PIC18F14K50 
 *      mikrovezrlhz val linker llomnyt (Project ablakban kattintson a fjlnvre jobb egrgombbal, majd a felbukkan ablakban vlassza a 
 *     Remove (eltvolts) menpontot a bal egrgombbal kattintva). Adja hozz a PIC18F4550-hez val linker PIC18f4550.lkr scriptet!  (Project men,
 *     Add File to Project menpontja, s tallzza be a common alknyvtrbl a  PIC18f4550.lkr llomnyt!)
 *      A piccolo_config.h llomnyban s az MPLINK parancssori opciinl (utbbi a Project men Build options ->  Project pontjban llthat be, az MPLINK
 *     lap kivlasztsa utn) adja meg a hasznlt bootloadert (HID_BOOTLOADER vagy MCHPUSB_BOOTLOADER). 
 *  -# Sikeres fordts utn indtsa el a  letltprogramot! HID booloaderhez a HIDBootLoader.exe llomnyt, MCHPUSB bootloaderhez 
 *       pedig a PDFSUSB.exe kell hasznlnia... 
 *  -# Egy USB kbellel kapcsolja ssze a szmtgpt s a PIC18 mikrovezrlt.Csatlakoztatskor tartsa lenyomva az SW1 nyomgombot,
 *       s csak a csatlakoztats utn 1-2 msodperccel engedje azt fel!
 *  -# A HID bootloader programban automatikusan trtnik a csatlakoztatott eszkz felismerse s a kapcsolds, a PDFSUSB programnl
*        r kell kattintani a Csatlakozs gombra. 
 *  -# Kattintson az Open HexFile gombra s navigljon a megnyl prbeszdablakban ahhoz az MPLAB projekt knyvtrhoz, amelyikben a ledflash programot lefordtotta!
 *  -# Vlassza ki a megfelel .hex llomnyt, s kattintson az Open (megnyits) gombra!
 *  -# Kattintson a Program/Verify gombra a letltprogram ablakban! Figyelje a program zeneteit!
 *  -# Ha a programletlts sikeresen befejezdtt, kattintson a Reset device (mikrovezrl jraindtsa) gombra, s gyeljen r, hogy 
 *       az SW1 gomb ekzben felengedett llapotban legyen!
 *  -# Ekkor a letlttt alkalmazi program elindul. Ellenrizze, hogy villognak-e a LED-ek! 
*
 * Ha sikeresen eljutott idig, akkor minden kszen ll ahhoz, hogy a PIC18 pldaprogramokat futtassa.
 * 
 * Cserny Istvn, PICCOLO projekt 2009-2010.
 */
