/* PICCOLO project
 * Copyright (c) 2009-2011 Istvan Cserny (cserny@atomki.hu)
 */

/** \file
 *  SPI tmogati fggvnyek. \see piccolo_spi.h
 */

#include "piccolo_config.h"
#include "piccolo_spi.h"

/** Az SPI modul konfigurlsa s engedlyezse az spi_mode  
 * paramterrel megadott mdban s adatsebessggel. A paramterek sszelltshoz
 * a piccolo_spi.h llomnyban definilt makrkat hasznlhatjuk.
 * \param spi_mode az \em SSPCON1 regiszterbe rand adat
 * \param spi_busmode az \em SSPSTAT regiszterbe rand adat 
 */
void spi_init(uint8 spi_mode, uint8 spi_busmode) {
  SSPSTAT = spi_busmode;
  SSPCON1 = spi_mode;
  switch(spi_mode & 0x0F) {
    case 5:                             //-- SLAVE md, SS bemenet letiltva
      SPI_SCK = 1;                      //SCK bemenet legyen
      break;
    case 4:                             //-- SLAVE md, SS bemenet engedlyezve
      SPI_SCK = 1;                      //SCK bemenet legyen
      SPI_SS  = 1;                      //SS  bemenet legyen
      break;
    default:                            //-- MASTER mdok
      SPI_SCK = 0;                      //SCK kimenet legyen
      break;
  }
  SPI_SDI = 1;                          //SDI legyen bemenet;
  SPI_SDO = 0;                          //SDO legyen kimenet 
      
  SSPCON1 |= SSPENB; 			// az MSSP egysg engedlyezse
}

/**
 * Kir egy bjtot a kimeneti bufferbe, kivrja, amg az tvitel lezajlik
 * s a bejv adatbjttal tr vissza. A PIC18F4550 Errata szerint az tvitel
 * vgt jelz BF bitet nem szabad kzvetlenl vizsglni, ezrt helyette a
 * programmegszakts jelzbitet vizsgljuk. Szintn az Errata ajnlja, hogy
 * adatklds eltt olvassuk ki az SSPBUF regisztert, ami egyttal trli a BF bitet.
 * Ha elmulasztjuk a BF bit trlst, akkor a kvetkez beolvasott adat nem msoldik t
 * az SSPBUF regiszterbe!  
 * \param data a kikldeni kvnt adat
 * \return a beolvasott adat
 */ 
uint8 spi_io( uint8 data) {
uint8 tmp;  
  PIR1bits.SSPIF = 0;                   // trli az interrupt jelzbitet
  SSPCON1bits.WCOL = 0;                 // trli az esetleges rs tkzs hibajelzt
  tmp = SSPBUF;                         // trli a BF jelzbitet
  SSPBUF = data;                        // kirakja a kimen adatot az SSPBUF regiszterbe
  while( !PIR1bits.SSPIF );             // megvrjuk a busz ciklus vgt 
  return (SSPBUF);                      // a vett bjttal trnk vissza
}



