/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

/** \file
 *  Ebben a header llomnyban konfigurlhatja a bootloader s az USB kapcsolat
 *  hasznlatval kapcsolatosos legfontosabb belltsokat. 
 *
 *  - <b>USE_USB:</b> Akkor definiljuk, ha hasznlni kvnjuk az USB kapcsolatot (\ref piccolo_config.h 
 *    llomnyban vagy az MPLAB IDE Project/Build Options/Project menjben definilhatjuk)
 *
 *  - <b>USE_INTERRUPT:</b> Akkor definiljuk, ha hasznlni kvnjuk a programmegszaktst 
 *    (vagy a \ref piccolo_config.h llomnyban, vagy az MPLAB IDE Project/Build Options/Project 
 *    menben definilhatjuk). <b>Figyelem! Programmegszakts esetn gondoskodnunk kell a magas s az 
 *    alacsony priorits interruptok kiszolglst ellt hi_isr() s lo_isr() eljrsokrl!</b>  
 *    Ha az USE_USB s az USE_INTERRUPT szimblumok definilva vannak, akkor automatikusan az
 *    USB_INTERRUPT szimblum is definilsra kerl, ellenkez esetben pedig az USB_POLLING 
 *    kerl definilsra. A \ref hello-int.c mintaprogramban lthat, hogy az USB interruptos 
 *    kiszolglsa hogyan vgezhet.
 *
 *  - <b>Blinking_at_start:</b> azt engedlyezhetjk vele, hogy LED1 s LED2 kijelezze az USB kapcsolat 
 *    llapott. A lehetsges rtkek: 0 = tilts, 1 = engedlyezs. 
 * 
 *  - <b>HID_BOOTLOADER:</b> Akkor definiljuk, ha HID bootloadert hasznlunk (vagy a \ref piccolo_config.h  
 *    llomnyban, vagy az MPLAB IDE Project/Build Options/Project menpontjban definilhatjuk). 
 *    Ezzel szinkronban a linker programnak is t kell adni a HID_BOOTLOADER szimbolumot 
 *    (parancssori /uHID_BOOTLOADER opci megadsa a Project/Build Options/Project menben, MPLINK belltsai lapjn).
 *   
 *  - <b>MCHPUSB_BOOTLOADER:</b> Akkor definiljuk, ha az MCHPUSB bootloadert hasznlunk (vagy a \ref piccolo_config.h  
 *    llomnyban, vagy a Project/Build Options/Project menben definilhatjuk). Ezzel szinkronban a
 *    Linker programnak is t kell adni a MCHPUSB_BOOTLOADER szimbolumot (parancssori /u opci megadsa
 *    a Project/Build Options/Project menben, MPLINK belltsai lapjn). 
 */

#ifndef PICCOLO_CONFIG_H
#define PICCOLO_CONFIG_H 

/*** USB hasznlat  **************************************************/
//-- Aktivlja a kvetkez sort az USB kapcsolat hasznlathoz! -------
//#define USE_USB

/*** Interrupt hasznlat  ********************************************/
//-- Aktivlja az albbi defincit a programmegszaktsok hasznlathoz! 
//#define USE_INTERRUPT 

/*** BlinkUSBStatus engedlyezse ************************************/
// A Blinking_at_start szimblum legyen mindig definlva, csupn az 
// rtkt mdostsa, ha szksges! 
// 1: Engedlyezi, hogy LED1 s LED2 jelezze az USB kapcsolat llapott
// 0: Tiltja, hogy LED1 s LED2 jelezze az USB kapcsolat llapott
#define Blinking_at_start 1

/* BOOTLOADER *********************************************************
* Az itteni defincival szinkronban a Linker szmra is definilja
* a HID_BOOTLOADER vagy MCHPUSB_BOOTLOADER szimblumot az MPLAB
* Project/Build options/Project menpontban az MPLINK Linker flre
* kattintva, s az Use Alternate Settings kivlasztsa utn, /u kapcsolval!  
**********************************************************************/
//--- Aktivlja az albbi sort a HID BOOTLOADER hasznlathoz
#define HID_BOOTLOADER

//--- Aktivlja az albbi sort az MCHPUSB BOOTLOADER hasznlathoz
//#define MCHPUSB_BOOTLOADER

//--- Egyidejleg csak egy bootloader-t definilhat!
#if defined(HID_BOOTLOADER) && defined(MCHPUSB_BOOTLOADER)
    #error "Egyidejleg nem definilhat ktfle bootloader-t!"
#endif

/*  HARDVER DEFINCIK BECSATOLSA ***********************************/
#if defined(__18F14K50)
  #include "p18f14k50.h"	
  #include "piccolo-14k50.h"
#elif defined(__18F4550)
  #include "p18f4550.h"	
  #include "piccolo-4550.h"
#else
   #error "A vlasztott mikrovezrlt nem tmogatja a PICCOLO project!"  
#endif


/*  Vltoztpusok s unik definilsa ******************************/
typedef unsigned char       uint8;   // 8 bites, eljel nlkli szm
typedef unsigned int        uint16;  //16 bites, eljel nlkli szm
typedef unsigned long       uint32;  //32 bites, eljel nlkli szm
typedef signed char         int8;    // 8 bites, eljeles szm
typedef signed int          int16;   //16 bites, eljeles szm
typedef signed long         int32;   //32 bites, eljeles szm

///Uni tpus sz s bjt elrssel 16 bites adatokhoz
typedef union _union16 { 
  uint16 word;
  struct {
    uint8 lo_byte;
    uint8 hi_byte;
  };
} union16;

///Uni tpus duplasz, sz s bjt elrssel 32 bites adatokhoz
typedef union _union32 {
  uint32 dword;
  struct {
    uint16 lo_word;
    uint16 hi_word;
  };
  uint8 byte[4];
} union32;

#endif
/*** EOF PICCOLO-GONFIG.H ********************************************/