/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

/** \file
 *  Ez az llomny deklarlja azokat a fggvnyeket, amelyekkel az
 *  alkalmazi programbl az USB kapcsolat kezelhetjk. Ezt az llomnyt
 *  a programjainkba kzvetlenl nem kell becsatolnunk. Ha definiltuk
 *  az USE_USB szimblumot, akkor a \ref piccolo_all.h llomnyban elhelyezett
 *  feltteles fordtsi parancsok gondoskodnak az automatikus becsatolsrl.
 *
 *  \see piccolo_usb.c a tovbbi rszletekrt.
 */

#ifndef PICCOLO_USB
#define PICCOLO_USB
	#include "GenericTypeDefs.h"
	#include "Compiler.h"
	#include "usb_config.h"
	#include "./USB/usb_device.h"
	#include "./USB/usb.h"
	#include "./USB/usb_function_cdc.h"
	
	/*  VLTOZK *********************************************************/
	#pragma udata
	extern char USB_In_Buffer[64];         // Az USB bemeneti buffere (ebbe runk...)
	extern char USB_Out_Buffer[64];        // Az USB kimeneti buffere (ebbl olvasunk...)
	extern BYTE numBytesRead;              // A vett karakterek szma
	extern BYTE numBytesToSend;            // Az elkldend karakterek szma
	extern BYTE Buffercp;                  // Mutat a buffer kiolvasshoz
	extern BYTE BlinkUSBStatus_enabled;    // USB sttusz kijelzs: 1=enged, 0=tilt
	
	/* FGGVNY PROTOTPUSOK *********************************************/
	void InitializeSystem(void);           // Rendszer inicializlsa (USB csatlakoztatsa)
	void ProcessIO(void);                  // USB karakterbufferek kezelse
	void USBDeviceTasks(void);             // USB kezelse (interrupt vagy polling)
	void BlinkUSBStatus(void);             // USB sttusz kijelzse (LED1 & LED2)
	unsigned int ReadPOT(void);            // Analg jel mrse (potmter)
	
	/** USB I/O FUNCTIONS ************************************************/ 
	int _user_putc(char c);                // Egy karakter kirsa
	#define usb_cdc_putc(c) _user_putc(c)  // Alternatv elnevezs a _user_putc() fggvnyhez
	void outString(const rom char* psz_s); // Szveg kiratsa
	char usb_cdc_getc(void);               // Egy karakter beolvassa  
	void outdec(long data, unsigned int ndigits); // Decimlis kirats adott szm tizedesjegyre 
	void out4hex(unsigned int t);          // Egy 16 bites szm kirsa hexadecimlisan
	unsigned int get4hex(void);	           // Ngyjegy hexadecimlis szm beolvassa
	unsigned char get2hex(void);	       // Ktjegy hexadecimlis szm beolvassa
	void delay_ms(unsigned int d);         // Ksleltet eljrs, ami ProcessIO()-t is rendszeresen meghvja 
	#define usb_cdc_kbhit() (Buffercp<numBytesRead) // Bemeneti buffer ellenrzse
#endif