/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include <stdio.h>
#include <delays.h>

/** \file
Az ipari szabvnynak tekinthet HD44780 vezrlvel elltott 2x16 karakateres
LCD kijelz kdtbljt mutatja be, 4 bites mdban. A CGRAM-ban a kisbets, 
magyar kezetes karaktereket is definiltuk. A kijelz vezrlse most is 4 
bites mdban trtnik. Az dvzl zenet megjelentse utn a kijelz 
karaktertbljt ktsoronknt jelentjk meg, s az SW1 nyomgomb lenyomsval 
lptethetjk tovbb. 

Ha soronknt legalbb 20 karaktert megjelent kijelznk van, akkor a sorok elejn
a kezd karakterkdot hexadecimlisan kir printf() utastst is aktivlhatjuk! 

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
   - 2x16 karakteres LCD kijelz, 4 bites zemmdban. Az adatvonalak a LEDport
     fels flbjtjra vannak ktve, a vezrl vonalak pedig a LEDport als bitjeire
     (RS = LED1, R/W = LED2, E = LED3). 
*/

unsigned char chk_busy;
unsigned char i,ch;
const rom unsigned char betwk[] = {0x02,0x04,0x0E,0x01,0x0F,0x11,0x0F,0x00,    //
                                   0x02,0x04,0x0E,0x11,0x1F,0x10,0x0E,0x00,    //
                                   0x02,0x04,0x0C,0x04,0x04,0x04,0x0E,0x00,    //
                                   0x02,0x04,0x0E,0x11,0x11,0x11,0x0E,0x00,    //
                                   0x02,0x04,0x11,0x11,0x11,0x13,0x0D,0x00,    //
                                   0x0A,0x00,0x11,0x11,0x11,0x13,0x0D,0x00,    //
                                   0x05,0x0A,0x11,0x11,0x11,0x13,0x0D,0x00,    //
                                   0x05,0x0A,0x0E,0x11,0x11,0x11,0x0E,0x00};   //


//-- A hardverfgg rszletek elklntse
#define RSHIGH()         LEDport |= 0x01;
#define RSLOW()          LEDport &= 0xFE;
#define RWHIGH()         LEDport |= 0x02;
#define RWLOW()          LEDport &= 0xFD;
#define EHIGH()          LEDport |= 0x04;
#define ELOW()           LEDport &= 0xFB;
#if defined(__18F14K50)
   #define BUSY_FLAG PORTCbits.RC7;
#elif  defined(__18F4550)
   #define BUSY_FLAG PORTDbits.RD7;
#endif 
#define DATA_DIR_RD()    LEDtris = 0xF0;
#define DATA_DIR_WR()    LEDtris = 0x00;
#define OUTPUT_DATA(x) {LEDport = (LEDport & 0x0F) | x;}

//-- Az E vezrljel pulzlsa 
void epulse(void){
    Delay10TCYx(2);  
    EHIGH();  Delay10TCYx(2); 
    ELOW(); Delay10TCYx(1);
}

//-- Egy bjt (parancs vagy adat) kirsa
void lcd_write(unsigned char cmd, 
               unsigned char data_flag, 
               unsigned char chk_busy, 
               unsigned char dflag){
char bflag,c;
  if (chk_busy) {
    RSLOW();                 //RS = 0 a foglaltsg figyelshez
    DATA_DIR_RD();           //adatvonalak vtelre lltsa
    RWHIGH();                //R/W = 1 olvasshoz
    do {
      EHIGH(); 
      Delay10TCYx(2);
      bflag = BUSY_FLAG;     //fels 4 bit olvassa
      ELOW(); Delay10TCYx(2);
      epulse();              //als flbjt kilptetse
    } while(bflag);
  } else {
    Delay10KTCYx(12);        //Foglaltsg figyels helyett ksleltets
  }
  DATA_DIR_WR();             //Adatvonalak rsra lltsa
  if (data_flag) { 
    RSHIGH();                //RS=1, ha adatklds kvetkezik
  }
  else RSLOW();              //RS=0, ha parancsot kldnk
  RWLOW();                   //R/W = 0, rshoz
  c = cmd & 0xF0;            //fels 4 bit kirsa
  OUTPUT_DATA(c);
  epulse();
  if (dflag) {
    c = (cmd & 0x0F)<<4;     //als 4 bit kirsa
    OUTPUT_DATA(c);
    epulse();
  }
}

//-- Az LCD modul inicializlsa
void lcd_init(void) {
//-- Az LCD-t vezrl vonalak inicializlsa
  DATA_DIR_WR();
  ELOW();
  RSLOW();
  RWLOW(); 
//-- Az LCD modul szoftveres reset-else s inicializlsa
  Delay10KTCYx(60);          //50 ms vrakozs az LCD felledsre 
  lcd_write(0x30,0,0,0);     //8 bites zemmd      
  Delay10KTCYx(6);           //5 ms vrakozs
  lcd_write(0x30,0,0,0);     // 4 bites zemmd
  lcd_write(0x30,0,0,0);     // 8 bites zemmd
  lcd_write(0x20,0,0,0);     // 4 bites zemmdba kapcsolunk
//-- Innen kezdve a 4 bites zemmd l (kldsnl dflag=1 kell)
  lcd_write(0x28,0,0,1);     // 2 soros display, 5x7 font
//-- Innen kezdve figyelhet a BF jelzbit (chk_busy=1)
  lcd_write(0x08,0,1,1);     // display letilts
  lcd_write(0x01,0,1,1);     // kpernytrls
  lcd_write(0x0C,0,1,1);     // display be, cursor, s villogs ki
  stdout = _H_USER;          // a felhasznli fggvny legyen a
                             // standard kimenet, ami az LCD-re r
}

void lcd_init_cgram(void) {
    lcd_write(0x40,0,1,1);  // kurzor a CGRAM elejre
    for(i=0; i<64; i++) {
      lcd_write(betwk[i],1,1,1);    // definilhat karakterek feltltse
    }                               // kezetes karakterekkel
    lcd_write(0x80,0,1,1);          // kurzor vissza, a DDRAM elejre	
}

//-- LCD-re egy karaktert kir fggvny a _H_USER stream szmra
void _user_putc(char cx) {
    switch(cx) {
	    case '':  cx = 0x00; break;
	    case '':  cx = 0x01; break;
	    case '':  cx = 0x02; break;
	    case '':  cx = 0x03; break;
	    case '':  cx = 0x04; break;
	    case '':  cx = 0x05; break;
	    case '':  cx = 0x06; break;
	    case '':  cx = 0x07; break;
	    case '':  cx = 0xEF; break;
    } 
    lcd_write(cx,1,1,1);
}

void main(void){
    DISABLE_ALL_ANALOG();           //Minden analg bemenet tiltsa
    mInitAllLEDs();                 // A LED-ek (RB0..RB3) inicializlsa 
    mInitSwitch1();                 // SW1 inicializlsa 
    lcd_init();                     // Az LCD modulinicializlsa 
    lcd_init_cgram();               // Az kezetes betk feltltse
    stdout = _H_USER;               // Az LCD legyen a standard kimenetnt
    printf(" Adjon az Isten ");
    lcd_write(0xC0,0,1,1);          // kurzor a msodik sor elejre    
    printf(" szebb jvt!   ");
    for(i=0; i<25; i++) {
      Delay10KTCYx(240);            // 25 x 200 ms vrakozs 
    }
    lcd_write(0x01,0,1,1);          // kpernytrls     
    ch = 0x00;
    while(1) {
      lcd_write(0x80,0,1,1);        // kurzor az els sor elejre
//-- Az albbi sor csak akkor aktivljuk, ha legalbb 20 karakteres LCD-t hasznlunk!
//    printf("%02x: ",ch);
      for(i=0; i<16; i++) {
        lcd_write(ch,1,1,1);
        ch++;
      }
      lcd_write(0xC0,0,1,1);        // kurzor a msodik sor elejre
//-- Az albbi sor csak akkor aktivljuk, ha legalbb 20 karakteres LCD-t hasznlunk!
//    printf("%02x: ",ch);
      for(i=0; i<16; i++) {
        lcd_write(ch,1,1,1);
        ch++;
      }
	  while(SW1);
      Delay1KTCYx(240);             // 20 ms vrakozs      	
	  while(!SW1);
      Delay1KTCYx(240);             // 20 ms vrakozs 
  }
}