/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include "xlcd.h"
#include "delays.h"

/** \file
Az ipari szabvnynak tekinthet HD44780 vezrlvel elltott 2x16 karakateres 
LCD kijelz hasznlatt mutatja be, 8 bites mdban, az MCC18 PIC18 perifriaknyvtrban
definilt fggvnyek segtsgvel. A program lefordtsa eltt el kell vgeznnk a
p18f14K50.lib, illetve p18f4550.lib llomny jrafordtst (hozz kell igaztani 
az LCD-vel kibvtett ksrleti ramkrhz),az 
\ref C18lib "A Microchip C18 v3.22 PIC18 perifriaknyvtr javtsai, mdostsai, hasznlata" 
c.lers tmutatst kvetve!


Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
   - 2x16 karakteres LCD kijelz. Az adatvonalak a LEDport-ra legyenek ktve, 
     a vezrl vonalak pedig a B portra (E = RB7, R/W = RB6, RS = RB5) 
*/
 
void DelayFor18TCY(void) {Delay10TCYx(2);  }        //20 TCY delay     
void DelayPORXLCD(void)  {Delay10KTCYx(60);}        //50 ms delay   
void DelayXLCD() 	 {Delay1KTCYx(60); }        	//5 ms delay
 
const rom char szoveg[]= "PICCOLO projekt";
         
void main(void) {   
   DISABLE_ALL_ANALOG();			//Minden analg bemenet tiltsa
   OpenXLCD( EIGHT_BIT & LINES_5X7 );
   while( BusyXLCD() );
   putrsXLCD(szoveg);				//Az els sor kirsa
   while( BusyXLCD() );
   SetDDRamAddr(0xC0);       		//Kurzor a msodik sor elejre
   while( BusyXLCD() );				//A msodik sor kirsa
#if defined(__18F14K50)
   putrsXLCD("PIC18F14K50 MCU");
#else
   putrsXLCD("PIC18F4550 MCU");
#endif
   while(1);   
}   