/* PICCOLO project
 * Copyright (c) 2009-2011 Istvan Cserny (cserny@atomki.hu)
 */

#include "piccolo_all.h"
#include "piccolo_spi.h"
#include "delays.h"

/** \file
* I2C mintaplda: egyszer parancsrtelmez segtsgvel rhatjuk/olvashatjuk
* az MCP23S17 16 bites perifriabvt regisztereit. Az I2C busz sebessgt is
* bellthatjuk.
*
* Az alkalmazhat parancsok:
*  - #Wrr,dd  az rr cm regiszterbe tlti a dd adatot
*  - #Rrr     kiolvassa s kirja az rr regiszter tartalmt
*  - #Srr     az SPI busz sebessgt 6_000_000/(rr+1) Hz-re lltja be
*/

#define MCP23S17ADDR 0x40   //MCP23S17 cme, fldre kttt cmvonalakkal
#define IODIRA_CIME 0x00
#define IODIRB_CIME 0x01
#define OLATA_CIME  0x14
#define OLATB_CIME  0x15

char cmd[32];
uint8 count,regaddr,data;

uint8 chr2hex(char a, char b) {
    if(a>0x40) {a -=7;}
    if(b>0x40) {b -=7;}
    return(((a & 0x0F)<<4) + (b & 0x0F)); 
} 


int main (void) {
  InitializeSystem();
  DISABLE_ALL_ANALOG();
  mInitAllLEDs();
  LEDport = 0;
  SLAVE_DISABLE();
  while (!usb_cdc_kbhit()) {                //Vrunk a CDC Terminlra
    ProcessIO();
  }
  outString("\nIsten hozott a PICCOLO projekthez!\n");
  outString("mcp23017_test.c program, MCU: ");
#if defined(__18F4550)
  outString("PIC18F4550\n");
#elif defined(__18F14K50)
  outString("PIC18F14K50\n");
#endif

//--- Alapbellts -----------------------
  PR2 = 59;                                  //peridus regiszter belltsa (60-1)
  OpenTimer2(TIMER_INT_OFF | T2_PS_1_1 | T2_POST_1_11 );
//-- Az SPI1 modul konfigurlsa 3 MHz-es, Mode_00 master mdba.
  spi_init(CKP_ACTIVE_HIGH |                //aktv llapotban az rajel magas szint
           MASTER_TMR2,                     //SPI rajel Timer2/2 (indulskor 100 kHz)
           SPI_CKE_ON |                     //kimenet aktv/inaktv tmenetkor (CKE=1)
           SPI_SMP_END);                    //A bemenetet az adatkimeneti id vgn mintavtelezzk
  MCP23S17_write(IODIRA_CIME,0);            //Az A port minden bitje legyen kimenet
  MCP23S17_write(IODIRB_CIME,0);            //Az A port minden bitje legyen kimenet
  MCP23S17_write(OLATA_CIME,0);             //Az A port kimeneti adatregiszternek belltsa
  MCP23S17_write(OLATB_CIME,0);             //A B port kimeneti adatregiszternek belltsa
  while (1) {
    outString("command: ");
    count=inStringEcho(cmd,30);
    if(cmd[0]=='#' && count>3) {
      regaddr=chr2hex(cmd[2],cmd[3]);
      switch(cmd[1]) {
        case 'W':
          data=chr2hex(cmd[4],cmd[5]);
          MCP23S17_write(regaddr,data);
        break;
        case 'R':
          MCP23S17_read(regaddr,&data);
          printf("Reg%d = %X\n",regaddr,data);
        break;
        default:
          outString("Pardon?\n");
        break;
      }
    } 
    else {
      outString("Valid commands are:");
      outString("#Wrrdd  - write dd to register rr");
      outString("#Rrr    - read register rr");
      outString("#Srr  - set speed to rr x 100 kHz ");  
    }
    doHeartbeat();
  }
}
