/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#define USE_OR_MASKS		//"VAGY" mvelettel egyesthet makrk legyenek
#define RD16_ON 0x80 		//T1CON kzvetlen rshoz ez a "j" makr
#include "timers.h"			//T1CON makrit akarjuk hasznlni
#include "stdio.h"			//printf() hasznlathoz kell

/** \file
* Mintaprogram Timer1 kls oszcilltora hasznlatnak bemutatsra.
* Timer1 a sajt, 32 kHz-es oszcilltornak peridusait szmllja.
* A 16 bites TMR1 szmll 2 msodpercenknt csordul tl, s okoz megszaktst.
* A megszaktsokat a sec, min s hour vltozkban szmoljuk.
*
* Az USB kapcsolaton egyszer parancsokat fogadunk:
*  -  Shhmmss - ra, perc s msodperc belltsa (hh,mm,ss ktjegy HEXADECIMLIS szmok!)
*  -  T - az aktulis id kirsa hh:mm:ss formtumban (a kirs decimlisan trtnik)
*
* Hardver igny:
*   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
*     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
*   - USB kapcsolat
*   - 32 kHz-es rakvarc s 2 db 33 pF kondenztor T1OSC zembehelyezshez	
*
*  Projekt konfigurci: A program mkdshez a HID_BOOTLOADER szimblumon kvl  
*  az USE_INTERRUPT s az USE_USB szimblumokat is definilni kell!
*/

#if !defined(USE_INTERRUPT) 
	#error "Nincs definilva az USE_INTERRUPT szimblum!"
#endif //USE_INTERRUPT
#if !defined(USE_USB)
	#error "Nincs definilva az USE_USB szimblum!"
#endif //USE_USB

char uc;						///<az USB-n vett karakter
volatile unsigned char hour,	///< ra
				min,			///<perc
				sec;			///<msodperc

//-- Magas priorits programmegszakts kiszolglsa
#pragma interrupt hi_isr
void hi_isr() {
#if defined(USB_INTERRUPT)
    USBDeviceTasks(); 			//--- USB programmegszakts kiszolglsa
#endif  //USB_INTERRUPT
}

//-- Alacsony priorits programmegszakts kiszolglsa
#pragma interruptlow lo_isr
void lo_isr() {
	if(PIR1bits.TMR1IF && PIE1bits.TMR1IE) {
		if((sec+=2)>59) {		//kt msodpercenknt trtnik megszakts
			sec=0; 
			if(++min>59) {
				min=0;
				if(++hour>23) hour=0;
			}
		}
	PIR1bits.TMR1IF=0;			//Timer1 interrupt jelzbitjnek trlse		
	}
}

void main(void) {

//-- A megszaktsi rendszer inicializlsa -----------------
	RCONbits.IPEN=1;			//Ktszint megszaktsi md belltsa
	INTCONbits.GIEH=1;			//A magas priorits interrupt engedlyezse
	INTCONbits.GIEL=1;			//Az alacsony priorits interrupt engedlyezse
    InitializeSystem();			//USB, LEDport, SW1 inicializlsa
//-- Timer1 konfigurlsa sajt rval (T1OSC)
	T1CON = RD16_ON 			//TMR1 16-bites rs/olvass md
			| T1_PS_1_1 		//Nincs eloszts
			| T1_OSC1EN_ON 		//T1OSC bekapcsolsa
			| T1_SYNC_EXT_ON 	//Kls bemenjel szinkronizlsa
			| T1_SOURCE_EXT;	//Kls jelforrs lpteti a TMR1 szmllt
	TMR1H=0;             		//TMR1 trlse
  	TMR1L=0;
	IPR1bits.TMR1IP=0;			//Timer1 megszakts alacsony priorits legyen
	PIR1bits.TMR1IF=0;			//Timer1 interrupt jelzbitjnek trlse
	PIE1bits.TMR1IE=1;			//Timer1 interrupt engedlyezse
  	T1CONbits.TMR1ON = 1;  		//Elindtja Timer1-et
//-- Kivrjuk az els karakter berkezst
    while (!usb_cdc_kbhit()) {
        ProcessIO();
    }
#if defined(__18F4550)
	outString("PICCOLO-4550");
#elif defined(__18F14K50)
	outString("PICCOLO-14K50");
#endif
    outString(" - rtc.c program\n");
    while (1) {
        do {
            uc=usb_cdc_getc();
        } while (uc!='T' && uc!='S');
        switch (uc) {
        case 'S':    					//SET: Az ra belltsa
			outString("SET = 0x");
  			T1CONbits.TMR1ON = 0;  		//Letiltja Timer1-et
            hour=get2hex();
            min=get2hex();
            sec=get2hex();
  			TMR1H=0;             		//TMR1 trlse
  			TMR1L=0;
  			T1CONbits.TMR1ON = 1;  		//jraengedlyezi Timer1-et
			usb_cdc_putc(' ');
//------- Szndkosan rcsorgatjuk a programot a TIME parancsra! --------
        case 'T':    					//TIME: Id kirsa
			printf("Time = %02u:%02u:%02u\r\n",hour,min,sec);
            break;
        } //switch
    } //while
}


