/* PICCOLO project
 * Copyright (c) 2009 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"

/** \file
Egyszer "Hell vilg!" mintaprogram, amely USB kapcsolaton keresztl
virtulis soros portknt kommunikl a szmtgppel, s minden vett
karakternek kirja a betjt s a kdjt (tzes szmrendszerben).

Ebben a programban USB kapcsolatot lekrdezses mdban kezeljk
(polling, ami az usb_cdc_getc eljrsban van elrejtve), ezrt a
program lefordtshoz csak az USE_USB szimblumot definiltuk, a
USE_INTERRUPT szimblumot nem!

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
   - USB kapcsolat
*/

char c;

void main(void) {
    InitializeSystem();
    //-- kivrjuk az els karakter berkezst
    while (!usb_cdc_kbhit()) {
        ProcessIO();
    }
    outString("Isten hozott a PICCOLO projekthez!\n");
    outString("hello-poll.c program (USB polling)\n");
    while (1) {
        c=usb_cdc_getc();
        printf("Vett karakter: %c = %d\r\n",c,c);
    }
}


