/* PICCOLO project
 * Copyright (c) 2009 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include <delays.h>
/** \file
Ledvillogtat program, amelyben kt-kt LED-et ellentemben villogtatunk.
A program az alapkapcsolsban szerepl ngy LED-et pronknt ellentemben  villogtatja.
A LED-ek PIC18F14k50 esetn az RC3..RC0 kivezetsekre, PIC18F4550 esetn pedig az
RD3..RD0 kivezetsekre csatlakoznak

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya

Mkdsi elv:
   - Kezdezben LED4-et s LED1-et bekapcsoljuk, LED3 s LED2 kikapcsolva maradnak
   - Vgtelen ciklusban ismteljk: 256 x 10 000 TCY ksleltets elteltvel a LED-ek
     llapott invertljuk. Az LEDport als 4 bitjt gy invertljuk, hogy LEDport-ot
     a 0x0f szmmal hozzuk bitenknti XOR (kizr vagy) kapcsolatba.
*/

void main(void) {
    LEDtris=0xf0;               //LEDport<3:0> legyen kimenet
    LEDport=0x09;               //kezdetben LED4 s LED1 legyenek bekapcsolva
    while (1) {
        Delay10KTCYx(0);        //2 560 000 TCY ksleltets
        LEDport = LEDport^0x0f; //LED-ek llapotnak invertlsa
    }
}
