/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"

/**     file
 *  Egyszer pldaprogram a bemeneti szint vltozst figyel funci
 *  kiprblsra.
 *  Az SW1 nyomgombhoz tartoz bemeneten a bemeneti szint megvltozsra 
 *  bekvetkez programmegszaktst engedlyezzk. A programmegszakts kiszolglsakor
 *  egy jezt belltunk, amelyet s fprogram fog felhasznlni. A fprogram figyeli a jelz 
 *  bebillenst s egy rtest zenetet r ki minden alkalommal, amikor az SW1 nyomgombot 
 *  lenyomjuk vagy felengedjk, s ennek hatsra szintvltozst jelz programmegszakts trtnik.
 *
 *  Hardver kvetelmnyek: a program az "A ksrleti ramkr" cm fejezetben bemutatott referencia 
 *  ramkrkn fut, az ramkr kiegsztsre/bvtsre nincs szksg.

 *  Projekt konfigurci: A program mkdshez a HID_BOOTLOADER szimblumon kvl az USE_USB 
 *  valamint az USE_INTERRPT szimblumokat is definilni kell.
 */

volatile char dummy, cFlag = 0;

//-- INTERRUPT KISZOLGL ELJRSOK ---------

///Magas priorits programmegszakts kiszolglsa
    #pragma interrupt hi_isr
    void hi_isr() {
        USBDeviceTasks();              //--- USB programmegszakts kiszolglsa
    }
///Alacsony priorits programmegszakts kiszolglsa
    #pragma interruptlow lo_isr
    void lo_isr() {                    //RA3 megvltozst jelz megszakts
    #if defined(__18F4550)
        dummy=PORTB;                   //PORTB jraolvassa sznteti meg a kivlt okot
        INTCONbits.RBIF=0;             //az interrupt jelzbit trlse
    #elif defined(__18F14K50)
        dummy=PORTA;                   //PORTA jraolvassa sznteti meg a kivlt okot
        INTCONbits.RABIF=0;            //az interrupt jelzbit trlse
    #endif
        cFlag = 1;                     //belltja az esemnyjelzt
    }


//-- Fprogram ----------------------
void main(void) {
    InitializeSystem();
    RCONbits.IPEN=1;                   //Ktszint interrupt md belltsa
    INTCONbits.GIEL=1;                 //Alacsony priorits interrupt engedlyezse
    //-- kivrjuk az els karakter berkezst
    while (!usb_cdc_kbhit()) {
        ProcessIO();
    }
    outString("change_test.c program,  ");
//-- az SW1-hez tartoz bemeneten a megvltozst jelz interrupt engedlyezse 
    #if defined(__18F4550)
        TRISB=0xFF;                    //legyen a B port minden lba digitlis bemenet
        INTCON2bits.RBPU=0;            //legyen B port minden lba felhzva (ne lebegjen)
        INTCONbits.RBIF=0;             //az IOCB interrupt jelzbit trlse
        INTCON2bits.RBIP=0;            //RBIF legyen alacsony priorits 
        INTCONbits.RBIE=1;             //a vltozsjelz interrupt engedlyezse        
        outString("PICCOLO-4550    n");
    #elif defined(__18F14K50)
        IOCAbits.IOCA3=1               //RA3 vltozsjelz interrupt engedlyezse
        INTCONbits.RABIF=0;            //az interrupt jelzbit trlse
        INTCON2bits.RABIP=0;           //RABIF legyen alacsony priorits 
        INTCONbits.RABIE=1;            //a vltozsjelz interrupt engedlyezse
        outString("PICCOLO-14K50    n");
    #endif
  while (1) {
    ProcessIO();                      //USB kapcsolat letben tartsa
    if (cFlag) {                      //ha az esemnyjelz be van lltva
      delay_ms(20);                   //kivrjuk a kontaktus pergsnek megsznsst
      cFlag = 0;                      //trljk az esemnyjelzt
      outString("SW1 llapota megvltozott!    n");
    }
  }
}
