/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#ifndef PICCOLO_4550_H
#define PICCOLO_4550_H

/** \file
 *  Ebben a header llomnyban a PIC18F4550 alap PICCOLO ksrleti ramkr
 *  hardver sajtossgait definiljuk. A konfigurcis bitek belltsaira
 *  csak abban az esetben van tnyleges szksgnk, ha nem hasznlunk bootloadert.
 *  Bootloaderes betltsnl ugyanis a konfigurcis biteket nem rjuk fell, a
 *  bootloaderrel egytt begetett konfigurcis bellts marad rvnyben.
 */  

    /*****************************************************************/
    /*** HARDVER belltsi opcik PIC18F4550 mintaramkrhz *******/
    /*****************************************************************/
		
	/*   KONFIGURCIS BITEK *****************************************/
	#if defined(PICCOLO_ALL)	            // Csak a fprogramhoz csatoljhatuk!
		#pragma config PLLDIV   = 5         // PLL oszt 20 MHz-es kristlyhoz
		#pragma config CPUDIV   = OSC1_PLL2   
		#pragma config USBDIV   = 2         // rajel forrsa a 96MHz PLL/2
		#pragma config FOSC     = HSPLL_HS  // HS oszcilltor s PLL az USB-hez is
		#pragma config FCMEN    = OFF       // Fail Safe Clock Monitor tiltsa
		#pragma config IESO     = OFF       // Bels/kls oszcilltor tiltsa
		#pragma config PWRT     = ON        // Bekapcsolskor 62 ms vrakozs
		#pragma config BOR      = ON        // Brown our Reset engedlyezve
		#pragma config BORV     = 2         // Reset szint = 2,7 V
		#pragma config VREGEN   = ON        // VUSB bels stabiliztorrl megy 
		#pragma config WDT      = OFF       // Watchdog timer letiltva
		#pragma config WDTPS    = 256       // Watchdog utszmll belltsa
		#pragma config MCLRE    = ON        // MCLR (reset) bemenet engedlyezve
		#pragma config LPT1OSC  = OFF       // T1OSC nagyobb teljestmny zemmd
		#pragma config PBADEN   = OFF       // PORTB<4:0> digitlis I/O-knt inicializldik
		#pragma config CCP2MX   = ON        // RC1 legyen a CCP2 kimenet
		#pragma config STVREN   = ON        // A verem tlcsordulsa RESET-et okoz
		#pragma config LVP      = OFF       // Alacsonyfeszltsg programozs letiltva
		#pragma config ICPRT    = OFF       // Dediklt programozi kivezets nincs
		#pragma config XINST    = OFF       // Extended Instruction Set
		#pragma config DEBUG    = OFF       // Httr nyomkvets letiltva, RB6/7 norml I/O
		#pragma config CP0      = OFF       // Kdvdelem kikapcsolva
		#pragma config CP1      = OFF
		#pragma config CP2      = OFF
		#pragma config CP3      = OFF
		#if defined(MCHPUSB_BOOTLOADER)     // A Boot blokkba csak ez a bootloader fr bele!
		    #pragma config CPB      = ON    // Boot Blokk kdvdelem bekapcsolva
		#else 
		    #pragma config CPB      = OFF   // Boot Blokk kdvdelem kikapcsolva
		#endif
		#pragma config CPD      = OFF
		#pragma config WRT0     = OFF       // rsvdelem kikapcsolva
		#pragma config WRT1     = OFF
		#pragma config WRT2     = OFF
		#pragma config WRT3     = OFF
		#if defined(MCHPUSB_BOOTLOADER)
		    #pragma config WRTB     = ON    // Boot Blokk rsvdelem bekapcsolva
		#else
		    #pragma config WRTB     = OFF   // Boot Blokk rsvdelem kikapcsolva
		#endif
		#pragma config WRTC     = OFF
		#pragma config WRTD     = OFF
		#pragma config EBTR0    = OFF       // Tblzatolvass ne legyen letiltva
		#pragma config EBTR1    = OFF
		#pragma config EBTR2    = OFF
		#pragma config EBTR3    = OFF
		#pragma config EBTRB    = OFF       //Boot blokk tblaolvass ne legyen letiltva
    #endif
	
    /*   USB rzkelk konfigurlsa *********************************/
    //  A PICCOLO projekt mintaramkrei nem tmogatjk az 
    //  USE_SELF_POWER_SENSE_IO tulajdonsgot, ezrt az albbi
    //  sort hagyja meg kommentnek!
    //--- #define USE_SELF_POWER_SENSE_IO

    #define tris_self_power     TRISAbits.TRISA2    // Input
    #if defined(USE_SELF_POWER_SENSE_IO)
    #define self_power          PORTAbits.RA2
    #else
    #define self_power          1
    #endif

    //  A PICCOLO projekt mintaramkrei nem tmogatjk az 
    //  USE_USB_BUS_SENSE_IO tulajdonsgot, ezrt az albbi
    //  sort hagyja meg kommentnek!
    //--- #define USE_USB_BUS_SENSE_IO
    #define tris_usb_bus_sense  TRISAbits.TRISA1    // Input
    #if defined(USE_USB_BUS_SENSE_IO)
    #define USB_BUS_SENSE       PORTAbits.RA1
    #else
    #define USB_BUS_SENSE       1
    #endif
	
    /*******************************************************************/
    /******** ramkri hardver elemek definilsa **********************/
    /*******************************************************************/
    #define CLOCK_FREQ 48000000

    /** LED-ek  ********************************************************/
    #define mInitAllLEDs()      LATD &= 0xF0; TRISD &= 0xF0;
    #define LEDport LATD
    #define LEDtris TRISD   
    #define mLED_1              LATDbits.LATD0
    #define mLED_2              LATDbits.LATD1
    #define mLED_3              LATDbits.LATD2
    #define mLED_4              LATDbits.LATD3
    
    #define mGetLED_1()         mLED_1
    #define mGetLED_2()         mLED_2
    #define mGetLED_3()         mLED_3
    #define mGetLED_4()         mLED_4

    #define mLED_1_On()         mLED_1 = 1;
    #define mLED_2_On()         mLED_2 = 1;
    #define mLED_3_On()         mLED_3 = 1;
    #define mLED_4_On()         mLED_4 = 1;
    
    #define mLED_1_Off()        mLED_1 = 0;
    #define mLED_2_Off()        mLED_2 = 0;
    #define mLED_3_Off()        mLED_3 = 0;
    #define mLED_4_Off()        mLED_4 = 0;
    
    #define mLED_1_Toggle()     mLED_1 = !mLED_1;
    #define mLED_2_Toggle()     mLED_2 = !mLED_2;
    #define mLED_3_Toggle()     mLED_3 = !mLED_3;
    #define mLED_4_Toggle()     mLED_4 = !mLED_4;
    
    /** SWITCH *********************************************************/
    #define mInitSwitch1()      TRISBbits.TRISB4=1;
    #define SW1                 PORTBbits.RB4
    #define sw2                 PORTBbits.RB4    // Just for compatibility
    
    /** I/O pin definitions ********************************************/
    #define INPUT_PIN 1
    #define OUTPUT_PIN 0

	#define I2C_SCL				TRISBbits.TRISB1
	#define I2C_SDA				TRISBbits.TRISB0 

    #define SPI_SDI             TRISBbits.TRISB0
    #define SPI_SCK             TRISBbits.TRISB1
    #define SPI_SDO             TRISCbits.TRISC7
    #define SPI_SS              TRISAbits.TRISA5

    /** POT ************************************************************/
    #define mInitPOT()          {TRISAbits.TRISA0=1;    \
                                 ADCON0=0x01;           \
                                 ADCON2=0x3C;           \
                                 ADCON2bits.ADFM = 1;}	// POT on RA0	

   /** ANALOG CSATORNK tiltsa/engedlyezse **************************/
   #define DISABLE_ALL_ANALOG() {CMCON  = 0b00000111;  ADCON1 = 0b00001111; } 
   #define ENABLE_ONE_ANALOG()  {CMCON  = 0b00000111;  ADCON1 = 0b00001110; } 
   #define ENABLE_TWO_ANALOG()  {CMCON  = 0b00000111;  ADCON1 = 0b00001101; } 
#endif  
/** EOF PICCOLO-4550.H *************************************************/
