/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include "delays.h"

/** \file
LED ki/bekapcsolsa nyomgombbal. 

Ez a program az SW1 gombbal vezrli a LED1 kijelz llapott:
   -# Az SW1 nyomgomb megnyomst s elengedst kveten LED1-et bekapcsoljuk.
   -# Az SW1 nyomgomb jabb megnyomst s elengedst kveten LED1-et kikapcsoljuk

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
     (ebben a programban az USB kapcsolatot nem hasznljuk)
*/

/** Ksleltet eljrs, amely a Microchip PIC18 knyvtri eljrsait hasznlja
 * A bels ciklus kb. 1 ms ksleltetst vgez. 
 * \param unsigned int d az elrt vrakozsi id, 1 ms egysgekben
 */
void delay_ms(unsigned int d) {
unsigned int i;
	for(i=0; i<d; i++) {
		Delay1KTCYx(12);		//12 000 TCY ksleltets (~ 1ms)
	}
}

//-- A fprogram -------------------------------------------
void main(void) {
	mInitAllLEDs();				//LED-ek inicializlsa
	mInitSwitch1();				//SW1 inicializlsa

	while (1) {
		while(SW1==1);			//lenyomsra vr
    	delay_ms(20);			//pergsmentest ksleltets
		while(SW1==0);			//felengedsre vr
    	delay_ms(20);			//pergsmentest ksleltets
		mLED_1_Toggle();		//LED1 llapotvlts
   }
}
