/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include "delays.h"

/** \file
LED ki/bekapcsolsa nyomgombbal II. 

Ez a program a vges llapotgp megkzeltssel valstja meg a LED1 kijelz 
SW1 nyomgombbal trtn vezrlst: 
   -# Az SW1 nyomgomb megnyomst s elengedst kveten LED1-et bekapcsoljuk.
   -# Az SW1 nyomgomb jabb megnyomst s elengedst kveten LED1-et kikapcsoljuk

Az llapotgpes megvalsts elnye az, hogy a nyomgomb lenyomsra/felengedsre
vrakozs kzben nem foglaljuk le a CPU idejt, hanem ms tevkenysg vgzsre is
lehetsget adunk. Itt most LED4-et villogtatjuk "letjelzknt", ~1 Hz-es frekvencival.

A nyomgomb pergsmentestst gy valstjuk meg, hogy a nyomgomb llapott csak 
bizonyos idkznknt (~20 ms) vizsgljuk, gy az adott idkznl rvidebb id 
alatt bekvetkez tbbszri llapotvltst (a kontaktusok pergst) nem rzkeli
a programunk. 

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
     (ebben a programban az USB kapcsolatot nem hasznljuk)
*/

typedef enum  { 
  WAIT_FOR_PRESS,				//Lenyomsra vr
  WAIT_FOR_RELEASE				//Felengedsre vr
} STATE12;

#define SW1_PRESSED()   SW1==0  //lenyomott llapot felttele
#define SW1_RELEASED()  SW1==1  //felengedett llapot felttele

/** Ksleltet eljrs, amely a Microchip PIC18 knyvtri eljrsait hasznlja
 * A bels ciklus kb. 1 ms ksleltetst vgez. 
 * \param unsigned int d az elrt vrakozsi id, 1 ms egysgekben
 */
void delay_ms(unsigned int d) {
unsigned int i;
	for(i=0; i<d; i++) {
		Delay1KTCYx(12);		//12 000 TCY ksleltets (~ 1ms)
	}
}

//-- A fprogram -------------------------------------------
void main(void) {
	STATE12 status;					//llapotjelz
	unsigned char c=25;				//szmll (25*20 ms ksleltetshez)
	mInitAllLEDs();					//LED-ek inicializlsa
	mInitSwitch1();					//SW1 inicializlsa
	status=WAIT_FOR_PRESS;			//kezdllapot
	while (1) {
//-- Nyomgomb llapotnak vizsglata 
		switch(status) {
		case WAIT_FOR_PRESS:
			if(SW1_PRESSED()) {
				mLED_1_Toggle();			//LED1 llapotvlts
				status=WAIT_FOR_RELEASE;	//kvetkez llapot
			}
			break;
		case WAIT_FOR_RELEASE:	
			if(SW1_RELEASED()) {
				status=WAIT_FOR_PRESS;		//kvetkez llapot
			}
			break;
		} //switch(status) vge
//-- Egyb tevkenysg (LED4 villogtatsa letjelzknt)
		if(--c==0) {
			mLED_4_Toggle();		//LED1 llapotvlts
			c=25;					//Visszaszmll belltsa
		}					
    	delay_ms(20);				//pergsmentest ksleltets
   } //while(1) ciklus vge
}
