/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include "delays.h"

/** \file
Egyszer adatgyjt program. Az els karakter berkezsekor
elindul a progam: kirja az dvzl zenetet. Ezutn periodikusan megmri
az analg bemenet jelt (a potmter llst) s kirja az USB kapcsolaton. 

Ha a program lefordtsa eltt az USE_USB s az USE_INTERRUPT szimblumokat
is definiljuk, akkor az USB kapcsolat kiszolglsa interrupt szinten
trtnik. Ha csak az USE_USB szimblumot definiljuk, akkor pedig lekrdezses
zemmdban trtnik a kezels,ugyangy, mint a hello-poll.c programnl.

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
   - USB kapcsolat
*/

unsigned int adat;
char c;

/*   INTERRUPT KISZOLGL ELJRSOK **********************************/
#if defined(USE_INTERRUPT)
	///Magas priorits programmegszakts kiszolglsa
	#pragma interrupt hi_isr
	void hi_isr() {
	#if defined(USB_INTERRUPT)
	    USBDeviceTasks(); //--- USB programmegszakts kiszolglsa
	#endif  //USB_INTERRUPT
	}
	///Alacsony priorits programmegszakts kiszolglsa
	#pragma interruptlow lo_isr
	void lo_isr() {
	}
#endif //USE_INTERRUPT

/** Ksleltet eljrs, amely az USB adatforgalom fenntartsrl is gondoskodik
 * ProcessIO() rendszeres hvogatsa tjn. A bels ciklus kb. 1 ms ksleltetst vgez.
 * \param unsigned int d az elrt vrakozsi id, 1 ms egysgekben
 */
void Delay_MS(unsigned int d) {
unsigned int i,j;
	for(i=0; i<d; i++) {
		for(j=0; j<50; j++) { 
	  		Delay100TCYx(1);
			ProcessIO();
		}
	}
}

void main(void) {
    InitializeSystem();
    while (!usb_cdc_kbhit()) {
        ProcessIO();                  //-- Megvrjuk az els karakter rkezst

    }
    outString("daq-int.c program, PICCOLO projekt \n");
    while (1) {
		while(usb_cdc_kbhit()) {
			c=usb_cdc_getc(); //"Elnyeljk a berkez karaktereket
		}
		adat=ReadPOT();
		out4hex(adat);
		usb_cdc_putc(0x0D);   //Kocsi vissza (CR)
		usb_cdc_putc(0x0A);   //Soremels (LF)
		Delay_MS(2000);    
    } //while
}     //main
