/* PICCOLO project
 * Copyright (c) 2009 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"

/** \file
Egyszer mintaprogram, az USB kapcsolat programmegszaktsos kezelsre.
Ha a program lefordtsa eltt az USE_USB s az USE_INTERRUPT szimblumokat
is definiljuk, akkor az USB kapcsolat kiszolglsa interrupt szinten
trtnik. Ha csak az USE_USB szimblumot definiljuk, akkor pedig lekrdezses
zemmdban trtnik a kezels, ugyangy, mint a hello-poll.c programnl.

Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
   - USB kapcsolat
*/

char c;

/*** INTERRUPT KISZOLGL ELJRSOK **********************************/
#if defined(USE_INTERRUPT)
	///Magas priorits programmegszakts kiszolglsa
	#pragma interrupt hi_isr
	void hi_isr() {
	#if defined(USB_INTERRUPT)
	    USBDeviceTasks(); //--- USB programmegszakts kiszolglsa
	#endif  //USB_INTERRUPT
	}
	///Alacsony priorits programmegszakts kiszolglsa
	#pragma interruptlow lo_isr
	void lo_isr() {
	}
#endif //USE_INTERRUPT

void main(void) {
    InitializeSystem();
    //-- kivrjuk az els karakter berkezst
    while (!usb_cdc_kbhit()) {
        ProcessIO();
    }
    outString("Isten hozott a PICCOLO projekthez!\n");
    outString("hello-int.c program (USB interrupton kezelve)\n");
    while (1) {
        c=usb_cdc_getc();
        printf("Vett karakter: %c = %d\r\n",c,c);
    }
}


