#include <LiquidCrystal_PCF8574.h>
#include <Wire.h>
#include <Adafruit_AM2315.h>

LiquidCrystal_PCF8574 lcd(0x20); // set the LCD address to 0x20

int show = -1;

void setup()
{
  int error;
  Wire.begin();
  Wire.beginTransmission(0x20);
  error = Wire.endTransmission();

  lcd.begin(20, 4); // initialize the lcd

} // setup()

void loop()
{
  if (show == 0) {
    lcd.setBacklight(0);
    lcd.home();
    lcd.clear();
  } // if
lcd.setBacklight(1);
Adafruit_AM2315 am2315;

float temperature, humidity;

  if (! am2315.readTemperatureAndHumidity(&temperature, &humidity)) {
    Serial.println("Failed to read data from AM2315");
    return;
  }
  lcd.print("Temp *C: "); lcd.print(temperature);
  lcd.print("      Hum   %: "); lcd.print(humidity);

  delay(2000);
    lcd.home();
    lcd.clear();
} // loop()
