#include "SampleFilter.h"

const int filter_taps[SAMPLEFILTER_TAP_NUM] = {
    4162,
    14846,
    17969,
    4626,
    -17951,
    -18775,
    21194,
    80115,
    108392,
    80115,
    21194,
    -18775,
    -17951,
    4626,
    17969,
    14846,
    4162
};

void SampleFilter_init(SampleFilter* f) {
  int i;
  for(i = 0; i < SAMPLEFILTER_TAP_NUM; ++i)
    f->history[i] = 0;
  f->last_index = 0;
}

void SampleFilter_put(SampleFilter* f, int input) {
  f->history[f->last_index++] = input;
  if(f->last_index == SAMPLEFILTER_TAP_NUM)
    f->last_index = 0;
}

int SampleFilter_get(SampleFilter* f) {
  long acc = 0;
  int index = f->last_index, i;
  for(i = 0; i < SAMPLEFILTER_TAP_NUM; ++i) {
    index = index != 0 ? index-1 : SAMPLEFILTER_TAP_NUM-1;
    acc += (long)f->history[index] * filter_taps[i];
  };
  return acc >> 19;
}
