#include <p18f1320.inc>
	LIST P=18f1320, F=INHX32
	CONFIG OSC=INTIO2				;Bels oszcilltor
	radix dec
	
;***********************************************

	CBLOCK 0x70
		pwm_duty
		pwm_loop
		Timer1
		Timer2
		Temp
		Temp2
		State
	ENDC

;***********************************************

Led1		equ 0	;RB0, 8-as lb, PORTB0 	Digitlis kimenet!
Led2		equ 1	;RB1, 9-es lb, PORTB1 	Digitlis kimenet!
Led3		equ 4	;RB4, 10-es lb, PORTB4	Digitlis kimenet!
Led4		equ 5	;RB5, 11-es lb, PORTB5	Digitlis kimenet!
Led5		equ 2	;RB2, 17-es lb, PORTB2	Digitlis kimenet!
Led6		equ 3	;RB3, 18-as lb, PORTB3	Digitlis kimenet!
Led7		equ	3	;RA3, 7-es lb, PORTA3	Digitlis kimenet!
NTC			equ 0	;RA0, 1-es lb, PORTA0	Analg bemenet!!!
Battery		equ 1	;RA1, 2-es lb, PORTA1	Analg bemenet!!!
Switch1		equ 2	;RA2, 6-os lb, PORTA2  Digitlis bemenet! 
Switch2		equ 3	;RA3, 7-es lb, PORTA3	Digitlis bemenet!

;***********************************************
;	pwm DutyCyle rtkek
;	0	=4.75v			100%=1.50v= 185		
;	10	=4.59v			 80%=2.23v= 152		
;	20	=4.43v			 60%=2.80v= 123		
;	30	=4.27v			 40%=3.15v= 101		
;	40	=4.12v			 20%=3.80v= 60
;	50	=3.96v			
;	60 	=3.80v
;	70	=3.64v
;	80	=3.48v
;	90	=3.32v
;	100	=3.16v
;	110	=3.00v
;	120	=2.85v
;	130	=2.69v
;	140	=2.48v	
;	150	=2.26v
;	160	=2.05v
;	170	=1.84v
;	180	=1.62v
;	190	=1.41v
;	200	=1.20v
;	210	=0.98v
;	220	=0.76v
;	230 =0.54v
;	240	=0.33v
;	250	=0.11v
;	255 =0.01v

;	NTC sszefggsek 5v tprl
;	25c=100k	
;	50c=36k
;	70c=18k
;	80c=12k
;	90c=10k
;	100=7k
;***********************************************
RES_V	CODE	0x00
		nop
		bra init

;***********************************************

		CODE				
init	movlw	B'01110000'				;frekvencia 8Mhz
		iorwf	OSCCON
		bcf		RCON, IPEN				;prioritsos megszaktsok tiltva
		clrf	INTCON					
		bcf		INTCON2, RBPU			;felhz ellenllsok be
		setf	ADCON1					;minden ANx lb digitlis
		clrf	TRISB					;PORTB lbak kimenetek
		setf	LATB
		bcf		TRISA,Led7
		bsf		LATA,Led7
		bsf		TRISA,Switch1			;PORTB2 (RA2) bemenet
		bsf		PORTA,Switch1
		movlw	1
		movwf	State					;llapot=00000001
		bra		polling

;*************************************************		
pwmloop	clrf	Temp2
pwm2	movlw	255						;DutyCycle rtke
		movwf	pwm_duty
		call	pwm
		decfsz	Temp2
		bra		pwm2
		bra		polling

	

;************************************
leds_off							;Ledek kikapcsolsa	
		bsf		LATB,Led1				
		bsf		LATB,Led2
		bsf		LATB,Led3		
		bsf		LATB,Led4
		bsf		LATB,Led5
		bsf		LATB,Led6
		bsf		LATA,Led7
		return		

;************************************
leds_on								;Ledek bekapcsolsa	
		bcf		LATB,Led1			
		bcf		LATB,Led2
		bcf		LATB,Led3		
		bcf		LATB,Led4
		bcf		LATB,Led5
		bcf		LATB,Led6
		bcf		LATA,Led7
		return

;*************************************		
delay	clrf	Timer1
		clrf	Timer2
delay1	decfsz	Timer1
		bra		delay		
		decfsz	Timer2
		bra		delay
		return

;*************************************		

pwm		clrf	pwm_loop
pwm1	addwf	pwm_duty,w
		btfss	STATUS, C
		call 	leds_off
		btfsc	STATUS, C
		call	leds_on
		
		decfsz	pwm_loop,f
		bra		pwm1
		return

;**************************************		

polling	btfss	PORTA, Switch1				;ha Sw1 megnyomva akkor goto sw1_push
		rlncf	State
		btfsc	State,0						;State=00000001 ?
		bra		pwmloop						;ha igen akkor vilgts pwm-nek megfelelen
		btfsc	State,1						;State=00000010 ?
		bra		polling		
		bra		polling
		
		
		
		end
			
	