
; Definitionen fr Mega8

; Belegungen der Atmel-Ports:

;*****************************************************************

;	PB0		ICP1		Periodendauer Eingang
;   PB1		OC1A		Segment DP
;   PB2		SS			Digit 1     
;   PB3		MOSI		Digit 2      
;   PB4		MISO		Digit 3
;   PB5		MSCK		Digit 4
;	PB6		XTAL1
;	PB7		XTAL2
				
;   PC0		ADC0		Spannung Eingang
;   PC1		ADC1		Clock Ausgang
;   PC2		ADC2		KEY	
;   PC3		ADC3		R IN					; 1M vom Eingang
;	PC4		I2C SDA		68k/10n					; bei Spannung gegen GND schalten
;	PC5		I2C SCL		27k						; bei 30V gegen GND schalten
;	PC6		RESET

;   PD0		RxD			Segment A		
;   PD1		TxD			Segment B
;   PD2		INT0		Segment C
;   PD3		INT1		Segment D
;   PD4	    T0			Segment E
;   PD5		T1			Frequenz Eingang			
;   PD6		AIN0		Segment F		
;   PD7		AIN1		Segment G		


;*****************************************************************

;--- Allgemeines -----------------------------------------------

.equ    F_CPU           = 16000000
.equ    CYCLES_PER_US   = ((F_CPU+500000)/1000000)

.equ	IRQ_TIME		= 1					; IRQ-Zeit in ms

.equ	VORTEILER		= 64
.equ	COUNT_IN		= F_CPU/VORTEILER	; Vorteiler 64 -> 250000Hz

.equ    TCONST_TIME     = (COUNT_IN/(1000/IRQ_TIME))-1 ; 250

.equ	OUT_CLOCK		= 1000				; extern Clock in kHz

.equ	KEY_WAIT		= 30				; ms Tasten-Entprellzeit

.equ	OFFSET_10V		= -4				; Korrekturfaktor Referenzspannung und Widerstnde
.equ	OFFSET_30V		= 14				; Korrekturfaktor Referenzspannung und Widerstnde

.equ	L_WERT_DEF		= 20				; * 10mV als Obergrenze L-Pegel
.equ	H_WERT_DEF		= 60				; in % von Ub als Untergrenze H-Pegel

;**************************** Port-Bits ***************************

.equ	SEG_PORT		= PORTD

.equ	SEG_A			= PD0
.equ	SEG_B			= PD1
.equ	SEG_C			= PD2
.equ	SEG_D			= PD3
.equ	SEG_E			= PD4

.equ	SEG_F			= PD6
.equ	SEG_G			= PD7

.equ	DIG_PORT		= PORTB

.equ	LOGIK_PORT		= PINB
.equ	LOGIK_PIN		= PB0

.equ	SEG_DP			= PB1

.equ	DIG_1			= PB2
.equ	DIG_2			= PB3
.equ	DIG_3			= PB4
.equ	DIG_4			= PB5

.equ	KEY_PORT		= PINC
.equ	KEY_PIN			= PC2

.equ	CLK_OUT			= PC1				; Ausgang auf L in Grundstellung

.equ	BER_DDR			= DDRC				; Port fr Spannungsteiler, Umschaltung auf hochohmig
.equ	BER_PORT		= PORTC				; Port fr Spannungsteiler, Umschaltung GND / Ub

.equ	BER_R_IN		= PC3				; 1M vom Eingang

.equ	BER_RC			= PC4				; C und 10V-Teilerwiderstand
.equ	BER_30V			= PC5				; 30V-Teilerwiderstand

;*************************** FLAGS IRQ *****************************

.equ	FLAG_KEY		= 0					; Taste als gedrckt erkannt 
.equ	FLAG_KEY_PRESS	= 1					; Taste noch nicht losgelassen

.equ	FLAG_FREQ		= 2					; Frequenzmessung gestartet
.equ	FLAG_PERIODE	= 3					; Periodendauermessung gestartet
.equ	FLAG_PERIOD_AKT	= 4					; Periodendauermessung Messzyklus luft
.equ	FLAG_PERIOD_PRE	= 5					; Periodendauermessung Prescale 8

;***************************** FLAGS ******************************

.equ	FLAG_IRQ		= 0					; 1ms IRQ wurde ausgefhrt

.equ	FLAG_U			= 1					; Spannung
.equ	FLAG_F			= 2					; Frequenz
.equ	FLAG_L			= 3					; Logik
.equ	FLAG_C			= 4					; Clock Out

;**************************** Ram-Reservierungen ******************

;--- Internes Ram ------------------------------------------------

.DSEG

.ORG    $060    

DIGIT_1:	.byte 1
DIGIT_2:	.byte 1
DIGIT_3:	.byte 1
DIGIT_4:	.byte 1

L_WERT:		.byte 2							; Wert * 10mV
H_WERT:		.byte 2							; Wert * 10mV

;**************************** Register ****************************

;--- lower Register -----------------------------------------------

.def	MUL_L		= r0
.def	MUL_H		= r1

; r2 noch frei

.def	TIMEOUT		= r3				; Periodendauer braucht 24 Bit fr entsprechend langes TIMEOUT bis 30HZ runter
.def	NULL		= r4
.def	SREG_SAVE	= r5

.def	ADC_WERT_L	= r6
.def	ADC_WERT_H	= r7

.def	CNT_WERT_L	= r8
.def	CNT_WERT_H	= r9

.def	KEY_TEMP	= r10					; Temp fr Taste

.def	DIV_L		= r12					; Divisor L 32/16Bit-Division
.def	DIV_H		= r13					; Divisor H 32/16Bit-Division

.def	ERG_L		= r14					; Ergebnis L 32/16Bit-Division
.def	ERG_H		= r15					; Ergebnis H 32/16Bit-Division

.def	BCD0		= r13					; BCD Wert Digits 1 und 0
.def	BCD1		= r14					; BCD Wert Digits 3 und 2
.def	BCD2		= r15					; BCD Wert Digit 4

.equ	BCD0_ADR	= 13					; Address von tBCD0
.equ	BCD2_ADR	= 15					; Address von tBCD1

;--- higher Register ----------------------------------------------

.def    TEMP_A      = r16                   ; Temp-Register, auch Dividend_LL 32/16Bit-Division
.def    TEMP_B      = r17                   ; Temp-Register, auch Dividend_LH 32/16Bit-Division
.def	TEMP_C		= r18                   ; Temp-Register, auch Dividend_HL 32/16Bit-Division
.def	TEMP_D		= r19					; Temp-Register, auch Dividend_HH 32/16Bit-Division

.def	FLAGS		= r20					; Flags fr Funktionen
.def	FLAGS_IRQ	= r21					; Flags der IRQ-Routinen

.def	KEY_CNT		= r22					; Taste Zhler entprellen

.def	DIG_NR		= r23					; Bit auf 1 fr Digit-Position
.def	DIG_ADR		= r24					; Low-Byte der Digit-Adresse im Ram
.def	DIG_DP		= r25					; Dezimalpunkt, 1 an Digitposition -> DP an

; r26/r27, r28/r29, r30/r31 fr X,Y,Z reserviert 

;--- Macros -------------------------------------------------------

.macro  load_p                      ; ldt 16Bit @1 nach @0 High und @0 Low

        ldi     @0H,HIGH(@1)
        ldi     @0L,LOW(@1)

.endmacro

