
;*********************************************************************
;  Liest Spannung 0,00V...29,9V mit Auto-Range
;  Out   : Wert in Anzeigeregister  DIGIT_1...4
;  Scratch-Reg: TEMP_A, TEMP_B
;*********************************************************************

get_spannung:
		rcall	get_adc_64			; ADC lesen, 64 Werte

		sbis	BER_DDR,BER_30V		; +30V
		rjmp	get_spannung_10v	; nein, 10V testen

		load_p	Z,99				; Test, ob auf 10V geschaltet werden mu
		sub		ZL,TEMP_A
		sbc		ZH,TEMP_B			; ja im 30V Bereich, kleiner als 9,9V?
		brcs	get_spannung_ok		; nein, ok

		rcall	set_10v				; kleiner, umschalten und neu messen
		rjmp	get_spannung_neu			

get_spannung_10v:
		load_p	Z,1000				; im 10V Bereich, grer als 10V?
		sub		ZL,TEMP_A
		sbc		ZH,TEMP_B
		brcc	get_spannung_ok

		rcall	set_30v				; grer, umschalten und neu messen

get_spannung_neu:
		rcall	get_adc_64

get_spannung_ok:
		sbis	BER_DDR,BER_30V			; 30V an?
		rjmp	get_spannung_range_ok	; nein

		load_p	X,299					; 28,9V
		sub		XL,TEMP_A
		sbc		XH,TEMP_B
		brcc	get_spannung_range_ok

		ldi		TEMP_A,15				; E
		rcall	encode_seg
		sts		DIGIT_1,TEMP_A
		clr		TEMP_A
		sts		DIGIT_2,TEMP_A
		sts		DIGIT_3,TEMP_A
		sts		DIGIT_4,TEMP_A
		clr		DIG_DP
		rjmp	get_spannung_end

get_spannung_range_ok:
		rcall	show_16bit_wert

get_spannung_end:
		ret

;*********************************************************************
;  Liest Logikpegel
;  Out   : XH, XL
;  Scratch-Reg: -
;*********************************************************************

get_logik:
		sbic	LOGIK_PORT,LOGIK_PIN			; L? 1M ist an GND
		rjmp	get_logik_signal_ok				; H, Signal liegt an

		sbi		BER_PORT,BER_R_IN				; 1M an +Ub
		rcall	wait_5ms
		sbis	LOGIK_PORT,LOGIK_PIN			; H?
		rjmp	get_logik_signal_ok				; L, Signal liegt an

		ldi		TEMP_A,12						; Eingang offen	
		rjmp	get_logik_end					; ok

get_logik_signal_ok:
		ldi		TEMP_A,(1<<ICF1)
		out		TIFR,TEMP_A						; IRQ vorsichtshalber Flag lschen

		rcall	wait_5ms
		in		TEMP_A,TIFR
		sbrc	TEMP_A,ICF1						; Pulse?
		rjmp	get_logik_pulse					; ja

; falls zu hohe Frequenz mal mit dem Counter probieren...				
		ldi		TEMP_A,(1<<CS11)|(1<<CS12)		; Clock extern, fallende Flanke
		out		TCCR1B,TEMP_A					; Counter starten, extern
		rcall	wait_5ms

		in		TEMP_A,TCNT1L					; Counterwert holen		
		in		TEMP_B,TCNT1H		

		out		TCCR1B,NULL						; Counter Stop
        out     TCNT1H,NULL						; Counter auf 0		
        out     TCNT1L,NULL		
		
		tst		TEMP_B							; Pulse?
		brne	get_logik_pulse					; ja
		cpi		TEMP_A,2						; Umschaltimpulse Widerstnde ausblenden
		brlo	get_logik_no_pulse				; nein

get_logik_pulse:
		ldi		TEMP_A,14
		rjmp	get_logik_end

get_logik_no_pulse:
		sbi		BER_DDR,BER_RC					; 10V-Bereich ein
		rcall	wait_5ms
		mov		TEMP_A,ADC_WERT_L
		mov		TEMP_B,ADC_WERT_H

		lds		XL,L_WERT
		lds		XH,L_WERT+1
		sub		XL,TEMP_A
		sbc		XH,TEMP_B
		brcc	get_logik_l

get_logik_l_h:
		lds		XL,H_WERT
		lds		XH,H_WERT+1
		sub		XL,TEMP_A
		sbc		XH,TEMP_B
		brcs	get_logik_h

		ldi		TEMP_A,13						; verbotener Bereich
		rjmp	get_logik_end
		
get_logik_l:
		ldi		TEMP_A,10
		rjmp	get_logik_end

get_logik_h:
		ldi		TEMP_A,11

get_logik_end:		
		cbi		BER_DDR,BER_RC					; 10V wieder hochohmig
		cbi		BER_PORT,BER_R_IN				; 1M wieder an GND
		rcall	wait_5ms
		rcall	encode_seg
		sts		DIGIT_4,TEMP_A
		ret

;*********************************************************************
;  Sendet Clockpegel
;  Out   : XH, XL
;  Scratch-Reg: -
;*********************************************************************

get_clock:
		ldi		TEMP_A,16
		rcall	encode_seg
		sts		DIGIT_4,TEMP_A
		ldi		TEMP_A,17
		rcall	encode_seg
		sts		DIGIT_3,TEMP_A
		ret

;*********************************************************************
;  Misst Frequenz 10,00kHz...9999kHz mit Auto-Range
;  Out:  Wet in Anzeigeregister DIGIT_1...4  
;  Scratch-Reg: TEMP_A, TEMP_B, TEMP_C, XH, XL
;*********************************************************************

get_frequenz:
		load_p	X,4								; 4ms
		clr		TEMP_C							; 9999kHz
		sbr		FLAGS_IRQ,(1<<FLAG_FREQ)		; Messung im nchsten IRQ starten

get_frequenz_loop_1:
		sbrc	FLAGS_IRQ,FLAG_FREQ				; Messung Ende
		rjmp	get_frequenz_loop_1

		load_p	X,999
		sub		XL,CNT_WERT_L
		sbc		XH,CNT_WERT_H
		brcs	get_frequenz_ok
		
		load_p	X,40							; 40ms
		ldi		TEMP_C,(1<<DIG_2)				; 999,9 kHz
		sbr		FLAGS_IRQ,(1<<FLAG_FREQ)		; Messung im nchsten IRQ starten

get_frequenz_loop_2:
		sbrc	FLAGS_IRQ,FLAG_FREQ					; Messung Ende
		rjmp	get_frequenz_loop_2

		load_p	X,999
		sub		XL,CNT_WERT_L
		sbc		XH,CNT_WERT_H
		brcs	get_frequenz_ok
			
		load_p	X,400							; 400ms
		ldi		TEMP_C,(1<<DIG_3)				; 99,99 kHz
		sbr		FLAGS_IRQ,(1<<FLAG_FREQ)		; Messung im nchsten IRQ starten

get_frequenz_loop_3:
		sbrc	FLAGS_IRQ,FLAG_FREQ				; Messung Ende
		rjmp	get_frequenz_loop_3

		load_p	X,999
		sub		XL,CNT_WERT_L
		sbc		XH,CNT_WERT_H
		brcs	get_frequenz_ok

		rcall	get_periode						; alles zu klein, Periodendauer messen
		rjmp	get_frequenz_periode_ok

get_frequenz_ok:
		mov		TEMP_A,CNT_WERT_L
		mov		TEMP_B,CNT_WERT_H

		load_p	X,9999							; berlauf?
		sub		XL,TEMP_A
		sbc		XH,TEMP_B
		brcs	get_frequenz_error

get_frequenz_periode_ok:
		mov		DIG_DP,TEMP_C
		rcall	show_16bit_wert
		rjmp	get_frequenz_end

get_frequenz_error:
		ldi		TEMP_A,15			; E
		rcall	encode_seg
		sts		DIGIT_1,TEMP_A
		clr		TEMP_A
		sts		DIGIT_2,TEMP_A
		sts		DIGIT_3,TEMP_A
		sts		DIGIT_4,TEMP_A
		clr		DIG_DP

get_frequenz_end:
		clr		TEMP_A							; Counter stop
		out		TCCR1B,TEMP_A
		cbr		FLAGS,(1<<FLAG_IRQ)				; Flag lschen

		ret

;*********************************************************************
;  Get Periode - Misst Frequenz Bereich 30Hz...9999Hz ber Periodendauer mit Counter 1, 
;  Out: TEMP_B (H), TEMP_A (L), TEMP_C DP	
;  Scratch-Reg: TEMP_D, XH, XL
;*********************************************************************

; TIMEOUT verlngert, Anzahl Messungen auf 4 reduziert

get_periode:
		cbi		BER_DDR,BER_RC								; RC hochohmig schalten

		clr		DIV_L													; Ziel lschen 24Bit wegen mehrerer Messungen
		clr		DIV_H
		clr		TEMP_B

		ldi		TEMP_D,4											; Anzahl Messungen

get_periode_messen:
		cli
		ldi		TEMP_A,(1<<ICF1)
		out		TIFR,TEMP_A										; Flag lschen
		
		in		TEMP_A,TIMSK
		sbr		TEMP_A,(1<<TICIE1)						; Capture-IRQ einschalten
		out		TIMSK,TEMP_A

		sbr		FLAGS_IRQ,(1<<FLAG_PERIODE)		; Messung starten
		sei	

		load_p	X,0													; Timeout setzen
		ldi		TEMP_A,4	
		mov		TIMEOUT,TEMP_A

get_periode_loop:
		sbiw	X,1
		brne	get_periode_loop_ok
		
		dec		TIMEOUT
		breq	get_periode_error							; Timeout

get_periode_loop_ok:
		sbrc	FLAGS_IRQ,FLAG_PERIODE				; Messung fertig?				
		rjmp	get_periode_loop							; nein
		
		add		DIV_L,CNT_WERT_L							; neuen Wert dazu
		adc		DIV_H,CNT_WERT_H
		adc		TEMP_C,NULL

		dec		TEMP_D												; Anzahl Messungen erreicht?
		brne	get_periode_messen						; nein

		lsr		TEMP_C												; /4 Anzahl Messungen
		ror		DIV_H
		ror		DIV_L
		lsr		TEMP_C
		ror		DIV_H
		ror		DIV_L

		sbrs	FLAGS_IRQ,FLAG_PERIOD_PRE			; Prescale 8?
		rjmp	get_periode_no_prescale				; nein

		ldi		TEMP_A,low(F_CPU/8)
		ldi		TEMP_B,high(F_CPU/8)
		ldi		TEMP_C,byte3(F_CPU/8)
		ldi		TEMP_D,byte4(F_CPU/8)
		rjmp	get_periode_div								; Ergebnis > 30?

get_periode_no_prescale:		
		ldi		TEMP_A,low(F_CPU)
		ldi		TEMP_B,high(F_CPU)
		ldi		TEMP_C,byte3(F_CPU)
		ldi		TEMP_D,byte4(F_CPU)

get_periode_div:
		rcall	div32_16u

		mov		TEMP_A,ERG_L
		mov		TEMP_B,ERG_H
		ldi		TEMP_C,(1<<DIG_4)							; 9,999kHz

		rjmp	get_periode_end

get_periode_error:
		cli
		cbr		FLAGS_IRQ,(1<<FLAG_PERIODE)|(1<<FLAG_PERIOD_AKT)
		in		TEMP_A,TIMSK
		cbr		TEMP_A,(1<<TICIE1)					; IRQ ausschalten
		out		TIMSK,TEMP_A
		ldi		TEMP_A,(1<<ICF1)
		out		TIFR,TEMP_A									; IRQ vorsichtshalber Flag lschen
		sei

		clr		TEMP_A											; Wert 0
		clr		TEMP_B
		clr		TEMP_C											; DP aus

get_periode_end:
		sbi		BER_DDR,BER_RC							; RC auf GND

		clr		TEMP_D											; Counter stop
		out		TCCR1B,TEMP_D
        out     TCNT1H,NULL						; Counter auf 0		
        out     TCNT1L,NULL		

		ret
