
; ATmega16

; Secure-Bits fr Mega8:
; gesetzt SUT0, CKOPT 

; 10.05.2007 M'Soft Berlin
; 03.10.2015 endlich Fehler in Periodendauer-Messung behoben...

.equ	VER		= '0'
.equ	REV		= '6'

.include "m8def.inc"

.include "Definitionen.inc"

;****************************** Verktor-Liste ************************

.CSEG
       rjmp    Reset


.ORG	OC2addr
		rjmp	irq_1ms

.ORG	ICP1addr
		rjmp	irq_capture

.ORG	OVF0addr
		rjmp	irq_overflow
				 
;****************************** Programm-Beginn **********************

;*********************************************************************
;  Initialisierungsroutine
;*********************************************************************

.ORG	INT_VECTORS_SIZE

; Hardware initialisieren

Reset:
		ldi     TEMP_A,low(RAMEND)          ; Stack an das interne Ram-Ende
        out     SPL,TEMP_A
		ldi     TEMP_A,high(RAMEND)
        out     SPH,TEMP_A

; Port B *************************************************************

; Digit-Treiber			
		clr		TEMP_A							; alle Digits aus			
        out     PORTB,TEMP_A                	
        ldi     TEMP_A,(1<<DIG_1)|(1<<DIG_2)|(1<<DIG_3)|(1<<DIG_4)|(1<<SEG_DP)
		out     DDRB,TEMP_A						; Digits Ausgang

; Port C *************************************************************

; ADC			
		ldi		TEMP_A,(1<<KEY_PIN)				; PullUp fr Taste ein, Ausgnge L			
        out     PORTC,TEMP_A 
		ldi		TEMP_A,(1<<CLK_OUT)|(1<<BER_RC)|(1<<BER_R_IN)	; RC an GND, R_IN an GND
		out     DDRC,TEMP_A

; Port D *************************************************************

; Segment-Treiber
		clr		TEMP_A			
        out     PORTD,TEMP_A                	; Alle Segmente aus
        ldi     TEMP_A,(1<<SEG_A)|(1<<SEG_B)|(1<<SEG_C)|(1<<SEG_D)|(1<<SEG_E)|(1<<SEG_F)|(1<<SEG_G)
        out     DDRD,TEMP_A						; Segmente Ausgang

; TIMER 2 - 1ms (8Bit) ***********************************************

;	Vorteiler 64, Timer 250

		ldi		TEMP_A,(1<<CS22)|(1<<WGM21)	    ; Prescale 64, CTC
		out		TCCR2,TEMP_A
        ldi     TEMP_A,TCONST_TIME				; Timer-Wert
        out     OCR2,TEMP_A		
		clr		TEMP_A
		out		ASSR,TEMP_A	
		ldi		TEMP_A,(1<<OCIE2)				; Timer-IRQ frei
        out     TIMSK,TEMP_A 

; TIMER 1 - Counter (16Bit) ******************************************

		clr		TEMP_A							; Timer als Counter
		out		TCCR1A,TEMP_A
		clr		TEMP_A							; Counter stop
		out		TCCR1B,TEMP_A
        out     TCNT1H,NULL						; Counter auf 0	-> Grundstellung in allen Funktionen am Ende wiederherstellen!	
        out     TCNT1L,NULL		

; TIMER 0 - extern Clock (8Bit) **************************************

		ldi		TEMP_A,(1<<CS00)			    ; Prescale 0
		out		TCCR0,TEMP_A
        ldi     TEMP_A,255-(F_CPU/(OUT_CLOCK*2000)); Timer-Wert
        out     TCNT0,TEMP_A		

; ADC ****************************************************************

		ldi		TEMP_A,(1<<REFS0)|(1<<REFS1)	; interne Referenz
		out		ADMUX,TEMP_A
		ldi		TEMP_A,(1<<ADEN)|(1<<ADSC)|(1<<ADFR)|(1<<ADPS2)|(1<<ADPS1)|(1<<ADPS0) ; Free Running und starten
		out		ADCSR,TEMP_A

;*********************************************************************				 

; Software initialisieren

		ldi		FLAGS,(1<<FLAG_U)				; Start mit Funktion Spannungsmesser
		clr		FLAGS_IRQ
		clr		NULL
		clr		DIG_DP							; alle Dezimalpunkte aus
		ldi		DIG_NR,(1<<DIG_1)				; Bit fr aktuelle Digitposition Digit 1
		ldi		DIG_ADR,low(DIGIT_1)			; Adresse Daten fr Digit 1

		sts		DIGIT_1,NULL					; Alle Segmente aus
		sts		DIGIT_2,NULL
		sts		DIGIT_3,NULL
		sts		DIGIT_4,NULL

		sei

		rcall	init							; ;Mit Ub und setzt Spannungs- und Logikparameter
					 
;*********************************************************************
;  Main-Loop
;*********************************************************************

main:	
		sbrs	FLAGS,FLAG_U			; Spannung messen?
		rjmp	main_freq				; nein

		rcall	set_10v

main_span:
		rcall	get_spannung
		ldi		TEMP_D,100				; Warteschleife, 100ms -> 10 Messungen/s
		rjmp	main_wait_loop

main_freq:
		sbrs	FLAGS,FLAG_F			; Frequenz messen
		rjmp	main_logik				; nein

		rcall	get_frequenz
		ldi		TEMP_D,100				; Warteschleife, 100ms -> 10 Messungen/s
		rjmp	main_wait_loop

main_logik:
		sbrs	FLAGS,FLAG_L			; Logikpegel
		rjmp	main_clock				; nein

		rcall	get_logik
		sbrs	FLAGS_IRQ,FLAG_KEY		; Taste gedrckt?
		rjmp	main_logik				; nein

		rjmp	main_wait_key

main_clock:
		rcall	get_clock
		sbrs	FLAGS_IRQ,FLAG_KEY		; Taste gedrckt?
		rjmp	main_clock				; nein

		rjmp	main_wait_key

main_wait_loop:
		sbrs	FLAGS,FLAG_IRQ			; auf IRQ warten
		rjmp	main_wait_loop

		cbr		FLAGS,(1<<FLAG_IRQ)		; Flag lschen fr nchsten IRQ

		sbrs	FLAGS_IRQ,FLAG_KEY		; Taste gedrckt?
		rjmp	main_wait_no_key		; nein

main_wait_key:
		rcall	key_decode				; Taste auswerten, wechselt Funktion U->F->L->C->U usw.
		rjmp	main_key_end

main_wait_no_key:
		dec		TEMP_D					; Warteschleife bei U und F
		brne	main_wait_loop

main_key_end:
		sbrc	FLAGS,FLAG_U			; Spannung messen
		rjmp	main_span

		sbrc	FLAGS,FLAG_F			; Frequenz messen
		rjmp	main_freq

		sbrc	FLAGS,FLAG_L			; Logik messen
		rjmp	main_logik

		sbrc	FLAGS,FLAG_C			; Clock ausgeben
		rjmp	main_clock

		rjmp	main					; hier sollten wir nie ankommen... ;)

;*********************************************************************				 


.include "Funktionen.inc"
.include "Subroutinen.inc"
.include "Irq.inc"
.include "Tabellen.inc"


