
;************** IRQ - Routinen ********************************************				 

;*********************************************************************
;  1ms Timer 2 Interrupt
;
;  Scratch-Reg: -
;*********************************************************************

irq_1ms:
		in		SREG_SAVE,SREG
		push	TEMP_A
		push	TEMP_B
		push	ZH
		push	ZL

		sbrs	FLAGS,FLAG_C				; Clock Out?
		rjmp	irq_1ms_no_clock			; nein

		sei									; IRQ wegen Overflow Timer 0 freigeben
		rjmp	irq_1ms_no_frequenz

irq_1ms_no_clock:
		sbrc	FLAGS_IRQ,FLAG_FREQ			; Frequenzmessung?
		rjmp	irq_1ms_frequenz			; ja

		sbrs	FLAGS_IRQ,FLAG_PERIODE		; Periodendauermessung?
		rjmp	irq_1ms_no_frequenz			; nein

		sei									; IRQ wegen Capture Timer 1 wieder freigeben
		rjmp	irq_1ms_display

irq_1ms_frequenz:
		ldi		TEMP_A,(1<<CS11)|(1<<CS12)	; Clock extern, fallende Flanke
		out		TCCR1B,TEMP_A				; Counter starten, extern
		sbiw	X,1							; Anzahl Durchlufe
		brcc	irq_1ms_no_frequenz			; nicht fertig	
				
		in		CNT_WERT_L,TCNT1L			; Counterwert holen		
		in		CNT_WERT_H,TCNT1H		

		cbr		FLAGS_IRQ,(1<<FLAG_FREQ)	; Flag lschen, fertig

		out		TCCR1B,NULL
        out     TCNT1H,NULL					; Counter auf 0		
        out     TCNT1L,NULL		

irq_1ms_no_frequenz:
		in		ADC_WERT_L,ADCL				; immer ADC-Wert holen
		in		ADC_WERT_H,ADCH

; ---> Tastenabfrage
		sbrc	FLAGS_IRQ,FLAG_KEY			; letzter Tastendruck schon bearbeitet?
		rjmp	irq_1ms_key_end				; nein

		in		TEMP_A,KEY_PORT				; Key-Status holen
		andi	TEMP_A,(1<<KEY_PIN)			; ausmaskieren
		cp		TEMP_A,KEY_TEMP				; gleicher Zustand?
		breq	irq_1ms_key_inc				; ja

		mov		KEY_TEMP,TEMP_A				; nein. merken
		clr		KEY_CNT						; Zhler auf 0
		rjmp	irq_1ms_key_end

irq_1ms_key_inc:
		inc		KEY_CNT						; Zhler erhhen
		cpi		KEY_CNT,KEY_WAIT			; Anzahl IRQs erreicht?
		brlo	irq_1ms_key_end				; nein

		clr		KEY_CNT						; ja, Zhler lschen
		sbrs	KEY_TEMP,KEY_PIN			; Taste ist losgelassen
		rjmp	irq_1ms_key_press			; nein. gedrckt
	
		cbr		FLAGS_IRQ,(1<<FLAG_KEY_PRESS)	; gedrckt-Flag lschen
		rjmp	irq_1ms_key_end
			
irq_1ms_key_press:
		sbrs	FLAGS_IRQ,FLAG_KEY_PRESS	; war noch nicht losgelassen
		sbr		FLAGS_IRQ,(1<<FLAG_KEY)|(1<<FLAG_KEY_PRESS)		; Taste gltig

irq_1ms_key_end:
		sbr		FLAGS,(1<<FLAG_IRQ)			; Flag fr neuen Wert

; ---> Display-Multiplex
irq_1ms_display:
		in		TEMP_A,DIG_PORT				; Digit-Zustand holen
		andi	TEMP_A,~((1<<DIG_1)|(1<<DIG_2)|(1<<DIG_3)|(1<<DIG_4)|(1<<SEG_DP))	; Digits und DP ausschalten
		out		DIG_PORT,TEMP_A

		ldi		ZH,high(DIGIT_1)			; erstes Digit -> H-Byte
		mov		ZL,DIG_ADR					; Digit-Nummer -> L-Byte
		ld		TEMP_B,Z					; Segment-Muster holen	

		out		SEG_PORT,TEMP_B				; und setzen

		in		TEMP_A,DIG_PORT				; Digit-Zustand holen, sind alle aus, aber restliche Portbits werden gebraucht
		or		TEMP_A,DIG_NR				; neue Digit-Nummer einschalten
		out		DIG_PORT,TEMP_A				; und setzen

		cp		DIG_NR,DIG_DP				; Dezimal-Punkt?
		brne	irq_1ms_no_dp				; nein

		sbi		DIG_PORT,SEG_DP				; ja, DP einschalten

irq_1ms_no_dp:
		inc		DIG_ADR						; nchste Adresse
		lsl		DIG_NR						; nchste Stelle, 0 wenn Ende
		brne	irq_1ms_end

		ldi		DIG_ADR,low(DIGIT_1)		; wieder auf Anfang
		ldi		DIG_NR,(1<<DIG_1)

irq_1ms_end:
		pop		ZL			
		pop		ZH
		pop		TEMP_B
		pop		TEMP_A
		out		SREG,SREG_SAVE
		reti

;*********************************************************************
;  Capture Timer 1 Interrupt
;
;  Scratch-Reg: -
;*********************************************************************

; lschen von TOV1 korrigiert

irq_capture:
		in		SREG_SAVE,SREG
		push	TEMP_A

		sbrc	FLAGS_IRQ,FLAG_PERIOD_AKT
		rjmp	irq_capture_stop								; Periode lief

    out   TCNT1H,NULL											; Counter auf 0		
    out   TCNT1L,NULL		

		ldi		TEMP_A,(1<<CS10)|(1<<ICNC1)			; Prescale 1 probieren
		out		TCCR1B,TEMP_A

		ldi		TEMP_A,(1<<TOV1)				
		out		TIFR,TEMP_A											; Flag lschen

		sbr		FLAGS_IRQ,(1<<FLAG_PERIOD_AKT)	; Flag setzen, Zyklus luft
		cbr		FLAGS_IRQ,(1<<FLAG_PERIOD_PRE)	; Prescale 1
		rjmp	irq_capture_end

irq_capture_stop:
		in		TEMP_A,TIFR
		sbrc	TEMP_A,TOV1											; berlauf?
		rjmp	irq_capture_overflow						; ja

		in		CNT_WERT_L,ICR1L								; Capturewert holen		
		in		CNT_WERT_H,ICR1H			

		cbr		FLAGS_IRQ,(1<<FLAG_PERIOD_AKT)|(1<<FLAG_PERIODE)	; Flag wieder lschen, Zyklus fertig			; 

		in		TEMP_A,TIMSK	
		cbr		TEMP_A,(1<<TICIE1)							; IRQ ausschalten
		out		TIMSK,TEMP_A
		rjmp	irq_capture_end

irq_capture_overflow:
    out   TCNT1H,NULL											; Counter auf 0		
    out   TCNT1L,NULL		

		ldi		TEMP_A,(1<<CS11)|(1<<ICNC1)			; Prescale 8
		out		TCCR1B,TEMP_A

		ldi		TEMP_A,(1<<TOV1)				
		out		TIFR,TEMP_A											; Flag lschen

		sbr		FLAGS_IRQ,(1<<FLAG_PERIOD_PRE)	; Flag setzen, Zyklus luft

irq_capture_end:
		pop		TEMP_A
		out		SREG,SREG_SAVE
		reti

;*********************************************************************
;  Overflow Timer 1 Interrupt
;
;  Scratch-Reg: -
;*********************************************************************

irq_overflow:
		in		SREG_SAVE,SREG
		push	TEMP_A
		push	TEMP_B

    ldi   TEMP_A,255-8					; Timer-Wert wieder setzen
    out   TCNT0,TEMP_A		

		ldi		TEMP_B,(1<<CLK_OUT)
		in		TEMP_A,BER_PORT					; Zustand Clock-Pin holen
		eor		TEMP_A,TEMP_B
		out		BER_PORT,TEMP_A

		pop		TEMP_B
		pop		TEMP_A
		out		SREG,SREG_SAVE
		reti
