
;**************************** Allgemeine Routinen **************************

;*********************************************************************
;  Key Decode
;  wechselt durch alle Funktionen U -> F -> L -> U usw.
;  Scratch-Reg: -
;*********************************************************************

key_decode:
		push	TEMP_A
		push	TEMP_B

		cbi		BER_DDR,BER_30V			; 30V hochohmig schalten
		cbi		BER_DDR,BER_RC			; RC hochohmig schalten

		sbrs	FLAGS,FLAG_U			; Spannung?
		rjmp	key_decode_no_u			; nein

; Spannung aus, Frequenz ein		
		cbr		FLAGS,(1<<FLAG_U)		; Spannung aus
		sbr		FLAGS,(1<<FLAG_F)		; Frequenz ein
		rjmp	key_decode_end

key_decode_no_u:
		sbrs	FLAGS,FLAG_F			; Frequenz?
		rjmp	key_decode_no_f			; nein

; Frequenz aus, Logik ein		
		cbr		FLAGS,(1<<FLAG_F)		; Frequenz aus
		sbr		FLAGS,(1<<FLAG_L)		; Logik ein
		sts		DIGIT_3,NULL
		sts		DIGIT_2,NULL
		sts		DIGIT_1,NULL
		clr		DIG_DP
		rjmp	key_decode_end

key_decode_no_f:
		sbrs	FLAGS,FLAG_L			; Logik?
		rjmp	key_decode_no_l			; nein

; Logik aus, Clock ein
		cbr		FLAGS,(1<<FLAG_L)		; Logik aus
		sbr		FLAGS,(1<<FLAG_C)		; Clock ein
		sbi		BER_DDR,BER_RC			; RC auf GND
		clr		DIG_DP
		cli
		in		TEMP_A,TIMSK
		sbr		TEMP_A,(1<<TOIE0)		; Timer 0 Overflow-IRQ einschalten
		out		TIMSK,TEMP_A
		sei		
		rjmp	key_decode_end

key_decode_no_l:
		sbrs	FLAGS,FLAG_C			; Clock?
		rjmp	key_decode_end			; nein

; Clock aus, Spannung ein
		cli
		in		TEMP_A,TIMSK
		cbr		TEMP_A,(1<<TOIE0)		; Timer 0 Overflow-IRQ ausschalten
		out		TIMSK,TEMP_A
		sei		

		cbi		BER_PORT,CLK_OUT		; Clock-Out wieder auf L
		cbr		FLAGS,(1<<FLAG_C)		; Logik aus
		sbr		FLAGS,(1<<FLAG_U)		; Spannung ein
		sbi		BER_DDR,BER_RC			; RC auf GND
		rcall	set_10v

key_decode_end:
		ldi		TEMP_B,KEY_WAIT

		cbr		FLAGS_IRQ,(1<<FLAG_KEY)
		cbr		FLAGS,(1<<FLAG_IRQ)

		pop		TEMP_B
		pop		TEMP_A
		ret

;*********************************************************************
;  Set 10V positiv
;
;  Scratch-Reg: -
;*********************************************************************

set_10v:
		cbi		BER_DDR,BER_30V				; 30V hochohmig schalten

		clr		DIG_DP
		sbr		DIG_DP,(1<<DIG_3)

		ret

;*********************************************************************
;  Set 30V positiv
;
;  Scratch-Reg: -
;*********************************************************************

set_30v:
		sbi		BER_DDR,BER_30V				; R an GND
		
		clr		DIG_DP
		sbr		DIG_DP,(1<<DIG_2)

		ret

;*********************************************************************
;  Holt die Spannung als Durchschnitt von 64 ADC-Werten und berechnet tatschlichen Spannungswert
;  Out   : TEMP_B (H), TEMP_A (L)
;  Scratch-Reg: TEMP_C, TEMP_D, XH, XL
;*********************************************************************

get_adc_64:
		clr		XH
		clr		XL
		ldi		TEMP_C,64				; 8*8
				
get_adc_64_wait:
		sbrs	FLAGS,FLAG_IRQ			; auf IRQ warten
		rjmp	get_adc_64_wait
		
		add		XL,ADC_WERT_L
		adc		XH,ADC_WERT_H
		cbr		FLAGS,(1<<FLAG_IRQ)		; Flag lschen
		dec		TEMP_C
		brne	get_adc_64_wait

		mov		TEMP_A,XL				; Dividend
		mov		TEMP_B,XH
		clr		TEMP_C
		clr		TEMP_D
				
		sbis	BER_DDR,BER_30V			; +30V
		rjmp	get_adc_64_no_30v

		load_p	X,(3*8*8)+OFFSET_30V			
		rjmp	get_adc_64_end

get_adc_64_no_30v:
		load_p	X,(8*8)+OFFSET_10V

get_adc_64_end:
		mov		DIV_L,XL
		mov		DIV_H,XH				; Divisor
		rcall	div32_16u
		mov		TEMP_A,ERG_L
		mov		TEMP_B,ERG_H

		ret

;*********************************************************************
;  Zeigt 16Bit-Wert an
;  Out   : Wert in Anzeigeregister DIGIT_1...4
;  Scratch-Reg: TEMP_A
;*********************************************************************

show_16bit_wert:
		rcall	bin2BCD16

		mov		TEMP_A,BCD0
		andi	TEMP_A,$0F
		rcall	encode_seg
		sts		DIGIT_1,TEMP_A

		mov		TEMP_A,BCD0
		swap	TEMP_A
		andi	TEMP_A,$0F
		rcall	encode_seg
		sts		DIGIT_2,TEMP_A
	
		mov		TEMP_A,BCD1
		andi	TEMP_A,$0F
		rcall	encode_seg
		sts		DIGIT_3,TEMP_A
	
		mov		TEMP_A,BCD1
		swap	TEMP_A
		andi	TEMP_A,$0F
		rcall	encode_seg

		sbrc	FLAGS,FLAG_U
		clr		TEMP_A						; bei Spannung nur 3 Stellen anzeigen
		sts		DIGIT_4,TEMP_A
		
		ret

;*********************************************************************
;  Wartet rund 10ms (10 IRQ-Aufrufe)
;  
;  Scratch-Reg: -
;*********************************************************************

wait_5ms:
		push	TEMP_A
		ldi		TEMP_A,5
		cbr		FLAGS,(1<<FLAG_IRQ)

wait_5ms_loop:
		sbrs	FLAGS,FLAG_IRQ
		rjmp	wait_5ms_loop

		cbr		FLAGS,(1<<FLAG_IRQ)
		dec		TEMP_A
		brne	wait_5ms_loop
		
		pop		TEMP_A
		ret

;*********************************************************************
;  Encode_Wert holt die Segmentdaten aus der Tabelle
;  OUT TEMP_A Segmentmuster
;  Scratch-Reg: TEMP_A, ZH, ZL
;*********************************************************************

encode_seg:
		load_p	Z,(2*seg_tab)
		add		ZL,TEMP_A
		adc		ZH,NULL
		lpm		TEMP_A,Z

		ret

;*********************************************************************
;  Init mit Ub und berechnet H_WERT
;  
;  Scratch-Reg: -
;*********************************************************************

init:
		load_p	X,L_WERT_DEF				; * 10mV
		sts		L_WERT,XL
		sts		L_WERT+1,XH

		ldi		TEMP_A,(1<<REFS0)|(1<<MUX3)|(1<<MUX2)|(1<<MUX1)	; AVcc als Referenz, Bandgap als In (1,23V)
		out		ADMUX,TEMP_A

		ldi		TEMP_A,2					; 2ms warten
		cbr		FLAGS,(1<<FLAG_IRQ)

init_loop_1:				
		sbrs	FLAGS,FLAG_IRQ
		rjmp	init_loop_1
		
		cbr		FLAGS,(1<<FLAG_IRQ)
		dec		TEMP_A
		brne	init_loop_1		

		clr		DIV_L						; Ziel fr Messerergebnis
		clr		DIV_H

		ldi		TEMP_A,8					; 8 Messungen

init_loop_mess:
		sbrs	FLAGS,FLAG_IRQ
		rjmp	init_loop_mess

		add		DIV_L,ADC_WERT_L
		adc		DIV_H,ADC_WERT_H

		cbr		FLAGS,(1<<FLAG_IRQ)
		dec		TEMP_A
		brne	init_loop_mess				; Summe 8 Messungen in DIV_H, DIV_L
		
		ldi		TEMP_A,low(101600)			; 1,23V Bandgap schon fr die Rechnung mit 8 Messwerten normalisiert
		ldi		TEMP_B,high(101600)
		ldi		TEMP_C,byte3(101600)
		ldi		TEMP_D,byte4(101600)	
		rcall	div32_16u					; durch Mewert teilen

		ldi		TEMP_A,H_WERT_DEF			; % von Ub
		mov		TEMP_B,ERG_L				; Ub * 10 aus obiger Messung
		subi	TEMP_B,-3					; 300mV fr Verpolschutzdiode dazu
	
		mul		TEMP_A,TEMP_B				; Ergebnis in MUL_H, MUL_L

		clr		DIV_H						; /10
		ldi		TEMP_A,10
		mov		DIV_L,TEMP_A

		mov		TEMP_A,MUL_L				; Dividend fr 32/16 Division						
		mov		TEMP_B,MUL_H
		clr		TEMP_C
		clr		TEMP_D
		rcall	div32_16u
								
		sts		H_WERT,ERG_L
		sts		H_WERT+1,ERG_H

		ldi		TEMP_A,(1<<REFS0)|(1<<REFS1)	; interne Referenz
		out		ADMUX,TEMP_A

		ret

;*********************************************************************
;  16Bit bin to BCD (eigentlich packed-BCD, immer 2 Stellen in einem Register)
;  In: TEMP_A (L), TEMP_B (H)
;  Out: BCD2 (x/4), BCD1 (3/2), BCD0 (1/0)
;  Scratch-Reg: TEMP_A, TEMP_B, TEMP_C, TEMP_D, ZH, ZL
;*********************************************************************

bin2BCD16:
		ldi		TEMP_C,16					; Bitzhler
		clr		BCD2						; Ergebnis lschen (3 bytes)
		clr		BCD1
		clr		BCD0
		clr		ZH

bin2BCD16_loop:
		lsl		TEMP_A						; Input schieben
		rol		TEMP_B						; durch alle Bytes
		rol		BCD0				
		rol		BCD1	
		rol		BCD2
		dec		TEMP_C						; Bitzhler
		breq	bin2BCD16_end				; fertig ?

		ldi		r30,BCD2_ADR+1				; Z auf Ergebnis MSB + 1

bin2BCD16_encode:
		ld		TEMP_D,-Z					; (Z) holen mit Pre-decrement
		subi	TEMP_D,-$03					; + $03
		sbrc	TEMP_D,3					; wenn Bit 3 nicht 0
		st		Z,TEMP_D					; speichern
		ld		TEMP_D,Z					; (Z) holen
		subi	TEMP_D,-$30					; + $30
		sbrc	TEMP_D,7					; wenn Bit 7 nicht 0
		st		Z,TEMP_D					; speichern
		cpi		ZL,BCD0_ADR					; alle erledigt??
		brne	bin2BCD16_encode			; nein, weiter

		rjmp	bin2BCD16_loop

bin2BCD16_end:
		ret

;*********************************************************************
;  32/16 Bit Division unsigned Dividend:Divisor=Ergebnis, Rest
;  In: TEMP_D (HH), TEMP_C (HL),TEMP_B (LH), TEMP_A (LL) Dividend,
;  In: DIV_H (H), DIV_L (L) Divisor
;  Out ERG_H (H), ERG_L (L) Ergebnis
;  Scratch-Reg: -
;*********************************************************************

div32_16u:
		clr		ERG_H 					; Clear Ergebnis-Register R7:R6
		clr		ERG_L					; Clear Ergebnis-Register R7:R6
		inc 	ERG_L					; Stopbit setzen fr 16 Divisionsschritte

div32_16_loop:
		lsl 	TEMP_A 					; Multipliziere Dividend mit 2
		rol 	TEMP_B
		rol 	TEMP_C
		rol 	TEMP_D
		brcs 	div32_16_sub			; Carry gesetzt? Dann 1!

		cp 		TEMP_D,DIV_H			; Vergleiche oberes Byte
		brcs 	div32_16_clear			; Ergebnis ist kleiner, also eine 0

		brne 	div32_16_sub			; Ergebnis ist grer, also eine 1

		cp 		TEMP_C,DIV_L			; Vergleich MSB gleich, vergleiche unteres Byte 
		brcs 	div32_16_clear			; Unteres Byte kleiner, also eine 0

div32_16_sub:
		sub 	TEMP_C,DIV_L			; Ziehe den Divisor von den oberen 16 Bit ab
		sbc 	TEMP_D,DIV_H
		sec 							; Setze das Carry-Bit, Ergebnis ist eine 1
		rjmp 	div32_16_set			; Zum Reinschieben in das Ergebnis

div32_16_clear:
		clc 							; Lsche Carry-Bit, Ergebnis ist eine 0

div32_16_set:
		rol 	ERG_L 					; Schiebe Carry-Bit von rechts in Ergebnis
		rol 	ERG_H
		brcc 	div32_16_loop			; Ende, wenn eine 1 links herausrollt

		ret


