#include <stdio.h>
#include "main.h"
#include "uart.h"

/* Uart IRQ priority */
#define UART_PRIORITY  255

//----------------------------------------------------------------------------
// portlb mdok (PP: push-pull, OD: open drain, FF: input floating)
#define MODE_ANALOG_INPUT     0x0
#define MODE_PP_OUT_10MHZ     0x1
#define MODE_PP_OUT_2MHZ      0x2
#define MODE_PP_OUT_50MHZ     0x3
#define MODE_FF_DIGITAL_INPUT 0x4
#define MODE_OD_OUT_10MHZ     0x5
#define MODE_OD_OUT_2MHZ      0x6
#define MODE_OD_OUT_50MHZ     0x7
#define MODE_PU_DIGITAL_INPUT 0x8
#define MODE_PP_ALTER_10MHZ   0x9
#define MODE_PP_ALTER_2MHZ    0xA
#define MODE_PP_ALTER_50MHZ   0xB
#define MODE_RESERVED         0xC
#define MODE_OD_ALTER_10MHZ   0xD
#define MODE_OD_ALTER_2MHZ    0xE
#define MODE_OD_ALTER_50MHZ   0xF

#define GPIOX_(a, b)          GPIO ## a
#define GPIOX(a)              GPIOX_(a)

#define GPIOX_PIN_(a, b)      b
#define GPIOX_PIN(a)          GPIOX_PIN_(a)

#define GPIOX_MODE_(a,b,c)    ((GPIO_TypeDef*)(((c & 8) >> 1) + GPIO ## b ## _BASE))->CRL = (((GPIO_TypeDef*)(((c & 8) >> 1) + GPIO ## b ## _BASE))->CRL & ~(0xF << ((c & 7) << 2))) | (a << ((c & 7) << 2))
#define GPIOX_MODE(a, b)      GPIOX_MODE_(a, b)

#define GPIOX_ODR_(a, b)      BITBAND_ACCESS(GPIO ## a ->ODR, b)
#define GPIOX_ODR(a)          GPIOX_ODR_(a)

#define GPIOX_IDR_(a, b)      BITBAND_ACCESS(GPIO ## a ->IDR, b)
#define GPIOX_IDR(a)          GPIOX_IDR_(a)

#define GPIOX_LINE_(a, b)     EXTI_Line ## b
#define GPIOX_LINE(a)         GPIOX_LINE_(a)

#define GPIOX_PORTSRC_(a, b)  GPIO_PortSourceGPIO ## a
#define GPIOX_PORTSRC(a)      GPIOX_PORTSRC_(a)

#define GPIOX_PINSRC_(a, b)   GPIO_PinSource ## b
#define GPIOX_PINSRC(a)       GPIOX_PINSRC_(a)

#define GPIOX_CLOCK_(a, b)    RCC_APB2ENR_IOP ## a ## EN
#define GPIOX_CLOCK(a)        GPIOX_CLOCK_(a)

#define GPIOX_PORTNUM_A       1
#define GPIOX_PORTNUM_B       2
#define GPIOX_PORTNUM_C       3
#define GPIOX_PORTNUM_D       4
#define GPIOX_PORTNUM_E       5
#define GPIOX_PORTNUM_F       6
#define GPIOX_PORTNUM_G       7
#define GPIOX_PORTNUM_H       8
#define GPIOX_PORTNUM_I       9
#define GPIOX_PORTNUM_J       10
#define GPIOX_PORTNUM_K       11
#define GPIOX_PORTNUM_(a, b)  GPIOX_PORTNUM_ ## a
#define GPIOX_PORTNUM(a)      GPIOX_PORTNUM_(a)

#define GPIOX_PORTNAME_(a, b) a
#define GPIOX_PORTNAME(a)     GPIOX_PORTNAME_(a)

//----------------------------------------------------------------------------
const uint8_t rcc_dividetable[] = {0, 0, 0, 0, 1, 2, 3, 4};

//----------------------------------------------------------------------------
// Itt lehet meghatrozni melyik uart-ot akarjuk hasznlni
#if USART1_BAUDRATE > 0 && (GPIOX_PORTNUM(USART1_RX) >= GPIOX_PORTNUM_A || GPIOX_PORTNUM(USART1_TX) >= GPIOX_PORTNUM_A)
#define USARTX                USART1
#define USARTX_IRQHandler     USART1_IRQHandler
#define USARTX_IRQn           USART1_IRQn
#define USARTX_CLOCLK_ON      RCC->APB2ENR |= RCC_APB2ENR_USART1EN;
#define USARTX_BRR_CALC       (SystemCoreClock >> rcc_dividetable[(RCC->CFGR & RCC_CFGR_PPRE2_Msk) >> RCC_CFGR_PPRE2_Pos]) / USART1_BAUDRATE
#define USARTX_RX             USART1_RX
#define USARTX_TX             USART1_TX
#define TXBUFX_SIZE           TXBUF1_SIZE
#define RXBUFX_SIZE           RXBUF1_SIZE
#define USARTX_PRINTF         USART1_PRINTF
#define USART_IO_SETMODE      GPIOX_MODE(MODE_FF_DIGITAL_INPUT, USART1_RX); GPIOX_MODE(MODE_PP_ALTER_50MHZ, USART1_TX)
#define usartx_inited         usart1_inited
#define txx_restart           tx1_restart
#define bufx_r                buf1_r
#define bufx_t                buf1_t
#define rbufx                 rbuf1
#define tbufx                 tbuf1
#define usartx_init           usart1_init
#define usartx_sendchar       usart1_sendchar
#define usartx_getchar        usart1_getchar
#define usartx_cbrx           usart1_cbrx
#include "uartx.h"
#endif

#if USART2_BAUDRATE > 0 && (GPIOX_PORTNUM(USART2_RX) >= GPIOX_PORTNUM_A || GPIOX_PORTNUM(USART2_TX) >= GPIOX_PORTNUM_A)
#define USARTX                USART2
#define USARTX_IRQHandler     USART2_IRQHandler
#define USARTX_IRQn           USART2_IRQn
#define USARTX_CLOCLK_ON      RCC->APB1ENR |= RCC_APB1ENR_USART2EN;
#define USARTX_BRR_CALC       (SystemCoreClock >> rcc_dividetable[(RCC->CFGR & RCC_CFGR_PPRE1_Msk) >> RCC_CFGR_PPRE1_Pos]) / USART2_BAUDRATE
#define USARTX_RX             USART2_RX
#define USARTX_TX             USART2_TX
#define TXBUFX_SIZE           TXBUF2_SIZE
#define RXBUFX_SIZE           RXBUF2_SIZE
#define USARTX_PRINTF         USART2_PRINTF
#define USART_IO_SETMODE      GPIOX_MODE(MODE_FF_DIGITAL_INPUT, USART2_RX); GPIOX_MODE(MODE_PP_ALTER_50MHZ, UASRT2_TX)
#define usartx_inited         usart2_inited
#define txx_restart           tx2_restart
#define bufx_r                buf2_r
#define bufx_t                buf2_t
#define rbufx                 rbuf2
#define tbufx                 tbuf2
#define usartx_init           usart2_init
#define usartx_sendchar       usart2_sendchar
#define usartx_getchar        usart2_getchar
#define usartx_cbrx           usart2_cbrx
#include "uartx.h"
#endif

#if USART3_BAUDRATE > 0 && (GPIOX_PORTNUM(USART3_RX) >= GPIOX_PORTNUM_A || GPIOX_PORTNUM(USART3_TX) >= GPIOX_PORTNUM_A)
#define USARTX                USART3
#define USARTX_IRQHandler     USART3_IRQHandler
#define USARTX_IRQn           USART3_IRQn
#define USARTX_CLOCLK_ON      RCC->APB1ENR |= RCC_APB1ENR_USART3EN;
#define USARTX_BRR_CALC       (SystemCoreClock >> rcc_dividetable[(RCC->CFGR & RCC_CFGR_PPRE1_Msk) >> RCC_CFGR_PPRE1_Pos]) / USART3_BAUDRATE
#define USARTX_RX             USART3_RX
#define USARTX_TX             USART3_TX
#define TXBUFX_SIZE           TXBUF3_SIZE
#define RXBUFX_SIZE           RXBUF3_SIZE
#define USARTX_PRINTF         USART3_PRINTF
#define USART_IO_SETMODE      GPIOX_MODE(MODE_FF_DIGITAL_INPUT, USART3_RX); GPIOX_MODE(MODE_PP_ALTER_50MHZ, USART3_TX)
#define usartx_inited         usart3_inited
#define txx_restart           tx3_restart
#define bufx_r                buf3_r
#define bufx_t                buf3_t
#define rbufx                 rbuf3
#define tbufx                 tbuf3
#define usartx_init           usart3_init
#define usartx_sendchar       usart3_sendchar
#define usartx_getchar        usart3_getchar
#define usartx_cbrx           usart3_cbrx
#include "uartx.h"
#endif

