#ifndef _UART1_H
#define _UART1_H

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------------------
/* Baud rate (if Baud Rate = 0 -> this Uart not used */
#define  USART1_BAUDRATE  0

/* RX, TX pin (if defined X, 0 -> not used */
#define  USART1_RX  A, 10
#define  USART1_TX  A, 9

#define  TXBUF1_SIZE 256      /* (2,4,8,16,32,64,128,256,512,...) */
#define  RXBUF1_SIZE 256      /* (2,4,8,16,32,64,128,256,512,...) */

/* printf redirect
   - 0: printf to uart disabled
   - 1: printf to uart eanbled
 */
#define  USART1_PRINTF  0

void     usart1_init(void);
char  usart1_sendchar(char c);
char  usart1_getchar(char * c);
__weak void usart1_cbrx(char rxch);

//----------------------------------------------------------------------------
/* Baud rate (if Baud Rate = 0 -> this Uart not used */
#define  USART2_BAUDRATE   115200

#define  USART2_RX  A, 3
#define  USART2_TX  A, 2

#define  TXBUF2_SIZE  512      /* (2,4,8,16,32,64,128,256,512,...) */
#define  RXBUF2_SIZE  256      /* (2,4,8,16,32,64,128,256,512,...) */

/* printf redirect
   - 0: printf to uart disabled
   - 1: printf to uart eanbled
 */
#define  USART2_PRINTF  1

void     usart2_init(void);
char  usart2_sendchar(char c);
char  usart2_getchar(char * c);
__weak void usart2_cbrx(char rxch);

//----------------------------------------------------------------------------
/* Baud rate (if Baud Rate = 0 -> this Uart not used */
#define  USART3_BAUDRATE  0

#define  USART3_RX  B, 11
#define  USART3_TX  B, 10

#define  TXBUF3_SIZE   256      /* (2,4,8,16,32,64,128,256,512,...) */
#define  RXBUF3_SIZE   256      /* (2,4,8,16,32,64,128,256,512,...) */

/* printf redirect
   - 0: printf to uart disabled
   - 1: printf to uart eanbled
 */
#define  USART3_PRINTF  0

void     usart3_init(void);
char  usart3_sendchar(char c);
char  usart3_getchar(char * c);
__weak void usart3_cbrx(char rxch);

#ifdef __cplusplus
}
#endif

#endif  //  _UART1_H
