#include <xc.h>
#define _XTAL_FREQ 20000000 //define crystal frequency to 20MHz

// CONFIG
#pragma config FOSC = XT     // Oscillator Selection bits (RC oscillator)
#pragma config WDTE = OFF       // Watchdog Timer Enable bit (WDT disabled)
#pragma config PWRTE = OFF      // Power-up Timer Enable bit (PWRT disabled)
#pragma config BOREN = OFF       // Brown-out Reset Enable bit (BOR disabled)
#pragma config CP = OFF      // Flash Program Memory Code Protection bit (Code protection off)

/*
#define ajto1 RA0
#define ajto2 RA1
#define ajto3 RA2
#define ajto4 RA3
#define ajto5 RB0
#define ajto6 RB1
 */

typedef unsigned char		BYTE;

typedef union _BYTE_VAL
{
  BYTE Val;

  struct
  {
    unsigned char b0 : 1;
    unsigned char b1 : 1;
    unsigned char b2 : 1;
    unsigned char b3 : 1;
    unsigned char b4 : 1;
    unsigned char b5 : 1;
    unsigned char b6 : 1;
    unsigned char b7 : 1;
  } bits;
} BYTE_VAL, BYTE_BITS;

BYTE_VAL porta = 0;
BYTE_VAL portb = 0;

#define ajto1 (porta.bits.b0)
#define ajto2 (porta.bits.b1)
#define ajto3 (porta.bits.b2)
#define ajto4 (porta.bits.b3)
#define ajto5 (portb.bits.b0)
#define ajto6 (portb.bits.b1)

void main()
{
  porta.Val = portb.Val + 128;
  portb.Val = porta.Val - 128;

  ADCON1 = 0x0F;
  TRISB=0x03; //Port-B as Output
  TRISA=0x1F; //RA as input
  while (1)
  {

    if ((ajto1 == 1) || (ajto3 == 1) || (ajto4 == 1))
    {
      PORTBbits.RB3=1;
    } else
    {
      PORTBbits.RB3=0;
    }

    if ((ajto2 == 1) || (ajto3 == 1) || (ajto5 == 1))
    {
      PORTBbits.RB5=1;
    } else
    {
      PORTBbits.RB5=0;
    }

    if ((ajto2 == 1) || (ajto4 == 1))
    {
      PORTBbits.RB4=1;
    } else
    {
      PORTBbits.RB4=0;
    }

    if (ajto2 == 1)
    {
      PORTBbits.RB2=1;
    } else
    {
      PORTBbits.RB2=0;
    }

    if (ajto4 == 1)
    {
      PORTBbits.RB6=1;
    } else
    {
      PORTBbits.RB6=0;
    }

    if (ajto6 == 1)
    {
      PORTBbits.RB7=1;
    } else
    {
      PORTBbits.RB7=0;
    }
  }
}