{ Insert Footprint Description                                              }

procedure TForm1.Button1Click(Sender: TObject);
Var
    Board    : IPCB_Board;
    Iterator : IPCB_BoardIterator;
    Comp     : IPCB_Component;
    Value,Foo1,S: string;
    Line,T   : string;
    I,p,ccnt      : integer;
    InputFile: TextFile;
    Va,Fo,Co,Nr : string;

begin
    button1.enabled:=false;
    Board := PCBServer.GetCurrentPCBBoard;
    If Board = Nil Then Exit;

    ccnt:=0;
    AssignFile(InputFile,'c:\Altium_Tools\SetFootDesc\ordernr.txt');
    Reset(InputFile);
    Try
        S:='Order Nr. Not Available';
        while not EOF(InputFile) do
        begin
            readln(InputFile,Line);
            Iterator := Board.BoardIterator_Create;
            Iterator.AddFilter_ObjectSet(MkSet(eComponentObject));
            Iterator.AddFilter_LayerSet(AllLayers);
            Iterator.AddFilter_Method(eProcessAll);

            Comp := Iterator.FirstPCBObject;
            PCBServer.PreProcess;

            For I := 1 to Length(Line) Do
            Begin
                Line[I] := LowerCase(Line[I]);
                p:=pos(',',Line);
                Va:=copy(Line,1,p-1);
                T:=copy(Line,p+1,length(Line)-p);

                p:=pos(',',T);
                Fo:=copy(T,1,p-1);
                T:=copy(T,p+1,length(T)-p);

                p:=pos(',',T);
                Co:=copy(T,1,p-1);
                Nr:=copy(T,p+1,length(T)-p);
            End;

            While (Comp <> Nil) do
            begin
                Value := LowerCase(Comp.GetState_Comment.Text);
                Foo1 := LowerCase(Comp.GetState_Pattern);
                //S:='Value: '+Value+' , FootPrint: '+Foo1;
                //Showmessage(S);
                If Not VarIsNull(line) Then
                Begin
                     if Va = Value then
                     begin
                          if Fo = Foo1 then
                          begin
                               S:=UpperCase(Co)+','+Nr;
                               Comp.SetState_FootprintDescription := S;
                               ccnt:=ccnt+1;
                               label3.caption:=inttostr(ccnt);
                               label3.update;
                          end;
                     end;
                end;
                Comp := Iterator.NextPCBObject;
            end;
            Board.BoardIterator_Destroy(Iterator);
            PCBServer.PostProcess;
        end;
    Finally
        CloseFile(InputFile);
    end;
    // Refresh PCB screen
    Client.SendMessage('PCB:Zoom', 'Action=Redraw' , 255, Client.CurrentView);
    button1.enabled:=true;
    Close;
end;

procedure TForm1.Form1Create(Sender: TObject);
begin
     form1.caption:='Order Nr. Filler';
     form1.left:=(screen.width-form1.width) div 2;
     form1.top:=(screen.height-form1.height) div 2;
end;



