unit Unit2;
// ***************************************
// Usibix, programm par Jean Brunet
// jean.brunet17@wanadoo.fr
// ***************************************
// Installer d'abord le driver du module USB.
// Puis quand l'interface est reconnue
// lancer le logiciel.
// Usibix : Fonctions : SetBit, ClrBit, ReadBit, WriteByte,
// ReadByte, PortStatus, Read_String.

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, D2XXUnit;

type
  TUsibix = class(TForm)
    GroupBox1: TGroupBox;
    Open: TBitBtn;
    Purge: TBitBtn;
    Read: TBitBtn;
    Memo1: TMemo;
    Clear: TBitBtn;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    OkConf: TButton;
    OkWrBit: TButton;
    OkRdBit: TButton;
    Panel1: TPanel;
    Appli2: TBitBtn;
    Hello: TBitBtn;
    Appli1: TBitBtn;
    Quitter: TButton;
    Button1: TButton;
    RC8: TCheckBox;
    RC7: TCheckBox;
    RC6: TCheckBox;
    RC5: TCheckBox;
    RC4: TCheckBox;
    RC3: TCheckBox;
    RC2: TCheckBox;
    RC1: TCheckBox;
    RE8: TCheckBox;
    RE7: TCheckBox;
    RE6: TCheckBox;
    RE5: TCheckBox;
    RE4: TCheckBox;
    RE3: TCheckBox;
    RE2: TCheckBox;
    RE1: TCheckBox;
    RL8: TCheckBox;
    RL7: TCheckBox;
    RL6: TCheckBox;
    RL5: TCheckBox;
    RL4: TCheckBox;
    RL3: TCheckBox;
    RL2: TCheckBox;
    RL1: TCheckBox;
    Aide: TBitBtn;
    GroupBox2: TGroupBox;
    B1: TBitBtn;
    B2: TBitBtn;
    B3: TBitBtn;
    B4: TBitBtn;
    B5: TBitBtn;
    B6: TBitBtn;
    B7: TBitBtn;
    B8: TBitBtn;
    procedure OpenClick(Sender: TObject);
    procedure PurgeClick(Sender: TObject);
    procedure ReadClick(Sender: TObject);
    procedure ClearClick(Sender: TObject);
    procedure HelloClick(Sender: TObject);
    procedure QuitterClick(Sender: TObject);
    procedure Appli1Click(Sender: TObject);
    procedure Appli2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OkConfClick(Sender: TObject);
    procedure OkWrBitClick(Sender: TObject);
    procedure OkRdBitClick(Sender: TObject);
    procedure B1Click(Sender: TObject);
    procedure B2Click(Sender: TObject);
    procedure B3Click(Sender: TObject);
    procedure B4Click(Sender: TObject);
    procedure B5Click(Sender: TObject);
    procedure B6Click(Sender: TObject);
    procedure B7Click(Sender: TObject);
    procedure B8Click(Sender: TObject);
    procedure AideClick(Sender: TObject);

  private
    { Dclarations prives }
  public
    { Dclarations publiques }
     Function Read_String : string;
     Function SetBit(dat : Byte) : Byte;
     Function ClrBit(dat : Byte) : Byte;
     Function ReadBit (dat : Byte): Boolean;
     Function WriteByte(dat : Byte): Byte;
     Function ReadByte : Byte;
     Function PortStatus(dat : Byte) : Byte;
     procedure BitON(B : Byte);
     procedure BitOFF(B : Byte);
  end;

var
  Usibix: TUsibix;
  stop, S1, S2, S3, S4, S5, S6, S7, S8, StatusOpen : boolean;
implementation

{$R *.dfm}

procedure TUsibix.OpenClick(Sender: TObject);
var
 PortStatus : FT_Result;
 S : String; I : Integer;
begin
  FT_Enable_Error_Report := false; // gestion des erreurs de D2XXUnit
  PortStatus := Close_USB_Device; // In case device was already open
  PortStatus := Open_USB_Device;  // Try and open device
  If PortStatus = FT_OK then      // Device is Now Present !
    Begin
      GetFTDeviceCount;
      S := IntToStr(FT_Device_Count);
      Memo1.Lines.add('Test USB 1.1 = ' + S+ ' Interface prsente(nt) ...');
      Reset_USB_Device;     // warning - this will destroy any pending data.
      Set_USB_Device_TimeOuts(5,5000); // read and write timeouts = 5000mS
      StatusOpen :=true;
    End
   else
    begin
       Memo1.Lines.add('Interface non branche ...');
       StatusOpen :=False;
    end;
end;

procedure TUsibix.PurgeClick(Sender: TObject);
 var
I : Integer;
begin
FT_Enable_Error_Report := false;
I:=Purge_USB_Device_Out;
if I <> FT_OK then     // Device no longer present ...
  Begin
     Memo1.Lines.add('Echec : Purge Out...');
  end
  else
    begin
      Memo1.Lines.add('Purge Out Ok...');
   end;
  I:=Purge_USB_Device_In;
  if I <> FT_OK then     // Device no longer present ...
  Begin
     Memo1.Lines.add('Echec : Purge In...');
  end
  else
  begin
      Memo1.Lines.add('Purge In Ok...');
  end;
end;

procedure TUsibix.ReadClick(Sender: TObject);
var
I : integer;
PortStatus : FT_Result;
begin
  PortStatus := Get_USB_Device_QueueStatus;
 If PortStatus <> FT_OK then     // Device no longer present ...
  Begin
     Memo1.Lines.add('Usibix ne rpond pas...');
     exit;
  end
  else
     Memo1.Lines.add(IntToStr(FT_Q_Bytes) + ' Bytes reu(s)...');
    if FT_Q_Bytes > 0 then
    begin
      I := Read_USB_Device_Buffer(FT_In_Buffer_Size);
      for I:=0 to FT_Q_Bytes - 1 do
         Memo1.Lines.add(chr(FT_In_Buffer[I]));
 end;
end;

procedure TUsibix.QuitterClick(Sender: TObject);
begin
  Close_USB_Device;
  Close;
end;

procedure TUsibix.ClearClick(Sender: TObject);
begin
  Memo1.Clear;
end;
procedure TUsibix.Appli1Click(Sender: TObject);
begin
    // autre code...
end;

procedure TUsibix.Appli2Click(Sender: TObject);
begin
    // autre code...
end;

procedure TUsibix.HelloClick(Sender: TObject);
var
I, FC1 :Integer;
begin
if StatusOpen = true then
begin
  FT_Enable_Error_Report := true;
  FC1:=1;   // NUMBER OF BYTES
  Memo1.Lines.add('PC-> Hello...');
  FT_Out_Buffer[0]:=8;
  I := Write_USB_Device_Buffer( FC1 );
  Memo1.Lines.add(Read_String);
end;  
end;

Function TUsibix.Read_String : string;
var
ch : string;
I : integer;
PortStatus : FT_Result;
begin
stop :=false;
 repeat
 begin
    Application.ProcessMessages;
    PortStatus := Get_USB_Device_QueueStatus;
    if stop=true then Break;
  end;
  until FT_Q_Bytes > 0;
  I := Read_USB_Device_Buffer(FT_In_Buffer_Size);
  for I:=0 to FT_Q_Bytes -1  do ch:=ch+ chr(FT_In_Buffer[I]);
  Read_String := ch;
end;
procedure TUsibix.Button1Click(Sender: TObject);
begin
  stop :=true;
end;

procedure TUsibix.FormCreate(Sender: TObject);
begin
  Memo1.Clear;
  StatusOpen:=false;
end;

procedure TUsibix.OkConfClick(Sender: TObject);
var
 data : byte;
begin
  data:=0;
  if RC1.Checked = true then data:=data+1;
  if RC2.Checked = true then data:=data+2;
  if RC3.Checked = true then data:=data+4;
  if RC4.Checked = true then data:=data+8;
  if RC5.Checked = true then data:=data+16;
  if RC6.Checked = true then data:=data+32;
  if RC7.Checked = true then data:=data+64;
  if RC8.Checked = true then data:=data+128;
  Memo1.Lines.add('PC-> Configuration du port du Sx...');
  PortStatus(data);
 end;

procedure TUsibix.OkWrBitClick(Sender: TObject);
var
data : byte;
begin
  data:=0;
  if RE1.Checked = true then data:=data+1;
  if RE2.Checked = true then data:=data+2;
  if RE3.Checked = true then data:=data+4;
  if RE4.Checked = true then data:=data+8;
  if RE5.Checked = true then data:=data+16;
  if RE6.Checked = true then data:=data+32;
  if RE7.Checked = true then data:=data+64;
  if RE8.Checked = true then data:=data+128;
  Memo1.Lines.add('PC-> Ecriture de 8 bits vers le Sx : ' + intToStr(data));
  WriteByte(data);
  S1:=False;
  S2:=False;
  S3:=False;
  S4:=False;
  S5:=False;
  S6:=False;
  S7:=False;
  S8:=False;
 end;

procedure TUsibix.OkRdBitClick(Sender: TObject);
var data : byte;
begin
  if statusOpen = true then
  begin
  data:=ReadByte;
  // ou pour chaque bit
  if(ReadBit(1)=true) then RL1.Checked:=true else RL1.Checked:=false;
  if(ReadBit(2)=true) then RL2.Checked:=true else RL2.Checked:=false;
  if(ReadBit(3)=true) then RL3.Checked:=true else RL3.Checked:=false;
  if(ReadBit(4)=true) then RL4.Checked:=true else RL4.Checked:=false;
  if(ReadBit(5)=true) then RL5.Checked:=true else RL5.Checked:=false;
  if(ReadBit(6)=true) then RL6.Checked:=true else RL6.Checked:=false;
  if(ReadBit(7)=true) then RL7.Checked:=true else RL7.Checked:=false;
  if(ReadBit(8)=true) then RL8.Checked:=true else RL8.Checked:=false;

  Memo1.Lines.add('PC-> Rception de 8 bits du Sx : ' + inttostr(data));
  end; 
  end;

// Usibix : Appel par les fonctions : SetBit, ClrBit, ReadBit, WriteByte, ReadByte, PortStatus
Function TUsibix.SetBit(dat : Byte) : Byte;
var
I, FC1:integer;
begin
  FT_Enable_Error_Report := true;
  FC1:=2;
  FT_Out_Buffer[0]:=4;
  FT_Out_Buffer[1]:=dat;
  I := Write_USB_Device_Buffer( FC1 );
end;

Function TUsibix.ClrBit(dat : Byte) : Byte;
var
I, FC1:integer;
begin
  FT_Enable_Error_Report := true;
  FC1:=2;
  FT_Out_Buffer[0]:=5;
  FT_Out_Buffer[1]:=dat;
  I := Write_USB_Device_Buffer( FC1 );
end;

Function TUsibix.ReadBit(dat : Byte) : Boolean;
// variable boolean Stop globale. Prvoir bouton 'Annuler'
var
I,FC1 :integer;
Db : Byte;
PortStatus : FT_Result;
begin
  ReadBit:=False;
  FT_Enable_Error_Report := true;
  FC1:=2;
  FT_Out_Buffer[0]:=6;
  FT_Out_Buffer[1]:=dat;
  I := Write_USB_Device_Buffer( FC1 );
  repeat
  begin
    Application.ProcessMessages;
    PortStatus := Get_USB_Device_QueueStatus;
    if stop=true then Break; // si blocage en lecture on stoppe
  end;
  until FT_Q_Bytes > 0;
  I := Read_USB_Device_Buffer(FT_In_Buffer_Size);
  Db:=FT_In_Buffer[0]; // On attend qu'un seul caractre
  if Db=1 then
     ReadBit:=True;
end;

Function TUsibix.WriteByte(dat : Byte) : Byte;
var
I, FC1:integer;
PortStatus : FT_Result;
begin
  FT_Enable_Error_Report := true;
  FC1:=2;
  FT_Out_Buffer[0]:=2;
  FT_Out_Buffer[1]:=dat;
  I := Write_USB_Device_Buffer( FC1 );
end;

Function TUsibix.ReadByte : Byte;
// variable boolean Stop globale. Prvoir bouton 'Annuler'
var
I,FC1 :integer;
PortStatus : FT_Result;
begin
  FT_Enable_Error_Report := true;
  FC1:=1;
  FT_Out_Buffer[0]:=3;
  I := Write_USB_Device_Buffer( FC1 );
  repeat
  begin
    Application.ProcessMessages;
    PortStatus := Get_USB_Device_QueueStatus;
    if stop=true then Break; // si blocage en lecture on stoppe
  end;
  until FT_Q_Bytes > 0;
  I := Read_USB_Device_Buffer(FT_In_Buffer_Size);
  ReadByte:=FT_In_Buffer[0]; // un caractre
end;

Function TUsibix.PortStatus(dat : Byte) : Byte;
var
I, FC1:integer;
begin
  FT_Enable_Error_Report := true;
  FC1:=2;
  FT_Out_Buffer[0]:=1;
  FT_Out_Buffer[1]:=dat;
  I := Write_USB_Device_Buffer( FC1 );
end;

procedure TUsibix.B1Click(Sender: TObject);
begin
  if S1=False then
  begin
    SetBit(1);
    S1:=True;
    RE1.Checked:=true;
    BitOn(1);
  end
  else
  begin
    ClrBit(1);
    S1:=False;
    RE1.Checked:=False;
    BitOff(1);
  end;
end;

procedure TUsibix.B2Click(Sender: TObject);
begin
  if S2=False then
  begin
    SetBit(2);
    S2:=True;
    RE2.Checked:=true;
    BitOn(2);
  end
  else
  begin
    ClrBit(2);
    S2:=False;
    RE2.Checked:=False;
    BitOff(2);
  end;
end;

procedure TUsibix.B3Click(Sender: TObject);
begin
  if S3=False then
  begin
    SetBit(3);
    S3:=True;
    RE3.Checked:=true;
    BitOn(3);
  end
  else
  begin
    ClrBit(3);
    S3:=False;
    RE3.Checked:=False;
    BitOff(3);
  end;
end;

procedure TUsibix.B4Click(Sender: TObject);
begin
    if S4=False then
  begin
    SetBit(4);
    S4:=True;
    RE4.Checked:=true;
    BitOn(4);
  end
  else
  begin
    ClrBit(4);
    S4:=False;
    RE4.Checked:=False;
    BitOff(4);
  end;
end;

procedure TUsibix.B5Click(Sender: TObject);
begin
     if S5=False then
  begin
    SetBit(5);
    S5:=True;
    RE5.Checked:=true;
    BitOn(5);
  end
  else
  begin
    ClrBit(5);
    S5:=False;
    RE5.Checked:=False;
    BitOff(5);
  end;
end;

procedure TUsibix.B6Click(Sender: TObject);
begin
    if S6=False then
  begin
    SetBit(6);
    S6:=True;
    RE6.Checked:=true;
    BitOn(6);
  end
  else
  begin
    ClrBit(6);
    S6:=False;
    RE6.Checked:=False;
    BitOff(6);
  end;
end;

procedure TUsibix.B7Click(Sender: TObject);
begin
    if S7=False then
  begin
    SetBit(7);
    S7:=True;
    RE7.Checked:=true;
    BitOn(7);
  end
  else
  begin
    ClrBit(7);
    S7:=False;
    RE7.Checked:=False;
    BitOff(7);
  end;
end;

procedure TUsibix.B8Click(Sender: TObject);
begin
    if S8=False then
  begin
    SetBit(8);
    S8:=True;
    RE8.Checked:=true;
    BitOn(8);
  end
  else
  begin
    ClrBit(8);
    S8:=False;
    RE8.Checked:=False;
    BitOff(8);
  end;
end;

procedure TUsibix.BitON(B : Byte);
begin
   Memo1.Lines.add('PC-> Bit '+inttostr(B)+ ' On');
end;

procedure TUsibix.BitOff(B : Byte);
begin
   Memo1.Lines.add('PC-> Bit '+inttostr(B)+ ' Off');
end;

procedure TUsibix.AideClick(Sender: TObject);
begin
   Memo1.Lines.add('                               Aide');
   Memo1.Lines.add(' ');
   Memo1.Lines.add('Pour vous connecter  Usibix,commencer par ouvrir le port USB avec "OPEN", puis cliquer sur "Purge" puis "Hello" et Usibix vous souhaitera la bienvenue. ');
   Memo1.Lines.add(' ');
   Memo1.Lines.add('Configurer le Port B du Sx en cochant les cases "Configuration Port" puis "Ok". Attention, les bits cochs sont en lecture');
   Memo1.Lines.add(' ');
   Memo1.Lines.add('Pour crire un octet cocher les cases "Ecrits Bits" puis "Ok".');
   Memo1.Lines.add(' ');
   Memo1.Lines.add('Pour lire un octet en "Lire bits" cliquer sur "Ok".');
   Memo1.Lines.add(' ');
   Memo1.Lines.add('Pour commander individuellement chaque bit cliquer sur chaque bouton "Bits On / Off". La validation se retrouve en "Ecrit Bits".');
   Memo1.Lines.add(' ');
   Memo1.Lines.add('Open, Purge, et Read sont des fonctions du Ft245.');
   Memo1.Lines.add(' ');
   Memo1.Lines.add('"Stop" interrompt la lecture du port USB.');
   Memo1.Lines.add(' ');
   Memo1.Lines.add('"Appli1" et "Appli2" sont laisss pour les programmeurs qui veulent tester leur code en modifiant le source.');
   Memo1.Lines.add(' ');
   Memo1.Lines.add('"Efface", efface cet cran, "Aide", vous avez dj trouv...');
   Memo1.Lines.add(' ');
   Memo1.Lines.add('Ce logiciel est un freeware, il ne peut tre vendu.');
   Memo1.Lines.add('Copyright : Jean Brunet. Avril 2005.');
end;

end.
