//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "D2xx.h"
#include "Func.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <string.h>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//-------      
void MyThread();           //  

//-------     
TForm1 *Form1;

TMenuItem * DevList[5];
char *BufPtrs[5]; 
char Dev1[64]; //     
char Dev2[64]; // b    
char Dev3[64]; //     
char Dev4[64]; //     

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CreateForm(TObject *Sender)//  
{ //-------- 
//     Form1
hPort=NULL;
hThread=NULL;
List1Num=0;
NumCicle=10;
WriteFlag=0;
NumDev=0;

//----   
ComboBox1->ItemIndex=0;
ComboBox2->ItemIndex=5;
ComboBox3->ItemIndex=3;
ComboBox4->ItemIndex=0;
ComboBox6->ItemIndex=0;

DevList[0]=Form1->N11;
DevList[1]=Form1->N21;
DevList[2]=Form1->N31;
DevList[3]=Form1->N41;

BufPtrs[0] = Dev1;
BufPtrs[1] = Dev2;
BufPtrs[3] = Dev3;
BufPtrs[4] = Dev4;
BufPtrs[5] = NULL;

SearchDevices(DevList,BufPtrs); //   

ThreadStart();                  // 
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)//  
{
char buf[4096], bb[30];
int proverka=0, schetchik=1;
long time;

Memo1->GetTextBuf(buf,4096);
if (Memo1->GetTextLen())
{
if (Form1->CheckBox1->Checked==true)
        schetchik=NumCicle;

proverka=WritePort(buf, strlen(buf), schetchik,&time);    //   

sprintf(bb," , : %d",time);
Label8->Caption=bb;

sprintf(bb," : %d /",(int)(8*strlen(buf)*schetchik*1000/time));
Label4->Caption=bb;

if (!proverka)
        MessageBox(0,"    ","Error",MB_OK|MB_ICONERROR);
}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::OnClose(TObject *Sender, TCloseAction &Action) //   
{
FT_STATUS ftStatus;
// 
GetExitCodeThread(hThread,&(Form1->ThExitCode));
ExitThread(ThExitCode);
//   
ftStatus=FT_SetBitMode(hPort,0xff,0);
if (ftStatus!=FT_OK)
        MessageBox(0,"   Bit Mode    ","Error",MB_OK|MB_ICONERROR);

ftStatus=FT_Purge(hPort,FT_PURGE_RX|FT_PURGE_TX);
if (ftStatus!=FT_OK)
        MessageBox(0,"    I/O","Error",MB_OK|MB_ICONERROR);

CloseHandle(hThread);
FT_Close(hPort);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)//   ()
{
Memo1->Clear();
Label6->Caption=" : 0";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)//   ()
{
ListBox1->Items->Clear();
List1Num=0;
Label7->Caption=" : 0";
}
//---------------------------------------------------------------------------

int TForm1::InitPort(int nDev)//    
{
char NumStr[10];
FT_STATUS ftStatus;

if (hPort!=NULL)
        {
        FT_Close(hPort);   //  
        hPort=NULL;
        }

ftStatus=FT_Open(nDev,&hPort);
if (ftStatus!=FT_OK)
        {
        MessageBox(0,"   ","Error",MB_OK|MB_ICONERROR);
        return 0;
        }
ftStatus=FT_SetUSBParameters(hPort,16384,16384);  //    
if (ftStatus!=FT_OK)
        {
        return 0;
        //     
        }
 
//----  
switch (ComboBox2->ItemIndex)
        {
        case 0: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_300);break;}
        case 1: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_600);break;}
        case 2: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_1200);break;}
        case 3: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_2400);break;}
        case 4: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_4800);break;}
        case 5: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_9600);break;}
        case 6: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_14400);break;};
        case 7: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_19200);break;}
        case 8: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_38400);break;}
        case 9: {ftStatus=FT_SetDivisor(hPort,0x8034);break;}
        case 10: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_57600);break;}
        case 11: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_115200);break;}
        case 12: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_230400);break;}
        case 13: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_460800);break;}
        case 14: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_921600);break;}
        case 15: {ftStatus=FT_SetDivisor(hPort,0x4001);break;}
        case 16: {ftStatus=FT_SetDivisor(hPort,1);break;}
        }
if (ftStatus!=FT_OK)
        {
        MessageBox(0,"    ", "Error",MB_OK|MB_ICONERROR);
        return 0;
        }

ftStatus=FT_SetDataCharacteristics(hPort,FT_BITS_8,FT_STOP_BITS_1,FT_PARITY_NONE);
if (ftStatus!=FT_OK)
        {
        MessageBox(0,"   (,,)", "Error",MB_OK|MB_ICONERROR);
        return 0;
        }

ftStatus=FT_SetTimeouts(hPort,5,5);
if (ftStatus!=FT_OK)
        {
        MessageBox(0,"   ", "Error",MB_OK|MB_ICONERROR);
        return 0;
        }

ftStatus=FT_SetBitMode(hPort,0xff,0);
if (ftStatus!=FT_OK)
        MessageBox(0,"   Bit Mode","Error",MB_OK|MB_ICONERROR);

ftStatus=FT_Purge(hPort,FT_PURGE_RX|FT_PURGE_TX);
if (ftStatus!=FT_OK)
        {
        MessageBox(0,"    I/O","Error",MB_OK|MB_ICONERROR);
        return 0;
        }
EnDis(true);

return 1;
}
//-----------------------------------------

void __fastcall TForm1::Memo1Change(TObject *Sender)//     ,   
{
int i;
char bb[100];
i=(int)Memo1->GetTextLen();
sprintf(bb," : %d",i);
Label6->Caption=bb;

}
//---------------------------------------------------------------------------

void MyThread()  //           
{
FT_STATUS ftStatus;
char out, bb[100];
DWORD  numout, RxBuf=0, TxBuf=0, EventStat;
char text[2048];
DWORD numin;

while (1)
        {
        ftStatus=FT_GetStatus(Form1->hPort,&RxBuf,&TxBuf, &EventStat);
        if (ftStatus!=FT_OK)
                {
                //MessageBox(hWnd,"    ","Error",MB_OK);
                }

        if (RxBuf!=0 && Form1->mode==0) //        
                {
                ftStatus=FT_Read(       //   
                Form1->hPort,
                &out,
                1,                      //   
                &numout);

                Form1->ListBox1->Items->Append(&out);
                if (Form1->List1Num%20000==0 && (Form1->List1Num)!=0)
                        {
                        Form1->ListBox1->Clear();
                        }
                sprintf(bb," : %d",++(Form1->List1Num));
                Form1->Label7->Caption=bb;
                
                if (ftStatus!=FT_OK)
                        {
                        MessageBox(0,"  ","Error",MB_OK|MB_ICONERROR);
                        }
                }
        else
                Sleep(1);
        }
}
//--------------------------------------------------

int TForm1::ThreadStart() //  
{
DWORD dwThreadId, dwThrdParam = 1;

hThread = CreateThread(
NULL,                        // default security attributes
0,                           // use default stack size
(unsigned long (__stdcall *)(void *))MyThread,  // thread function
&dwThrdParam,                // argument to thread function
0,                           // use default creation flags
&dwThreadId);                // returns the thread identifier

if (hThread==NULL)
        {
        MessageBox(0,"  !","ERROR",MB_OK);
        return 0;
        }
SetThreadPriority(        //  
  hThread,
  THREAD_PRIORITY_LOWEST
);
return 1;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::OnNumCicleChange(TObject *Sender)
{
NumCicle=ComboBox6->Text.ToInt();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)  //   
{
FT_STATUS ftStatus;
unsigned char bit;
int buf[8];

ftStatus=FT_GetBitMode(hPort,&bit);
if (ftStatus!=FT_OK)
        MessageBox(0,"    ","Error",MB_OK|MB_ICONERROR);
for (int i=0;i<8;i++)
        {
        buf[i]=bit%2;
        bit=bit>>1;
        }
for (int ind=0;ind<8;ind++)
        {
        if (buf[ind])
                ((TCheckBox *)FindComponent("CheckBox"+IntToStr(ind+22)))->Checked=true;
        else
                ((TCheckBox *)FindComponent("CheckBox"+IntToStr(ind+22)))->Checked=false;
        }
}

//-------------------------    Bit Bang Mode
int TForm1::OutByteSet()
{
char out;
DWORD numin;
FT_STATUS ftStatus;
int code=0;

if (CheckBox14->Checked==true) code=code+1;
if (CheckBox15->Checked==true) code=code+2;
if (CheckBox16->Checked==true) code=code+4;
if (CheckBox17->Checked==true) code=code+8;
if (CheckBox18->Checked==true) code=code+16;
if (CheckBox19->Checked==true) code=code+32;
if (CheckBox20->Checked==true) code=code+64;
if (CheckBox21->Checked==true) code=code+128;

if (Form1->mode)  
        {
        out=(char)code;
        ftStatus=FT_Write(hPort, &out, 1, &numin);
        if (ftStatus!=FT_OK)
                MessageBox(0,"    ","Error",MB_OK|MB_ICONERROR);
        }
return 1;
}
void __fastcall TForm1::CheckBox14Click(TObject *Sender)
{
OutByteSet();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox15Click(TObject *Sender)
{
OutByteSet();        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox16Click(TObject *Sender)
{
OutByteSet();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox17Click(TObject *Sender)
{
OutByteSet();        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox18Click(TObject *Sender)
{
OutByteSet();        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox19Click(TObject *Sender)
{
OutByteSet();        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox20Click(TObject *Sender)
{
OutByteSet();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox21Click(TObject *Sender)
{
OutByteSet();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{
if (GroupBox1->Visible)
        Button6->Caption="Bit Mode  >>>";
else
        Button6->Caption="Bit Mode  <<<";

GroupBox1->Visible=!GroupBox1->Visible; 
}
//---------------------------------------------------------------------------


void __fastcall TForm1::N4Click(TObject *Sender)
{
Form1->Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N2Click(TObject *Sender)
{
SearchDevices(DevList,BufPtrs);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N11Click(TObject *Sender)
{
InitPort(0);
NumDev=0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N21Click(TObject *Sender)
{
InitPort(1);
NumDev=1;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N31Click(TObject *Sender)
{
InitPort(2);
NumDev=2;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N41Click(TObject *Sender)
{
InitPort(3);
NumDev=3;
}

//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox2Change(TObject *Sender)
{
FT_STATUS ftStatus;
switch (ComboBox2->ItemIndex)
        {
        case 0: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_300);break;}
        case 1: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_600);break;}
        case 2: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_1200);break;}
        case 3: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_2400);break;}
        case 4: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_4800);break;}
        case 5: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_9600);break;}
        case 6: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_14400);break;};
        case 7: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_19200);break;}
        case 8: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_38400);break;}
        case 9: {ftStatus=FT_SetDivisor(hPort,0x8034);break;}
        case 10: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_57600);break;}
        case 11: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_115200);break;}
        case 12: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_230400);break;}
        case 13: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_460800);break;}
        case 14: {ftStatus=FT_SetBaudRate(hPort,FT_BAUD_921600);break;}
        case 15: {ftStatus=FT_SetDivisor(hPort,0x4001);break;}
        case 16: {ftStatus=FT_SetDivisor(hPort,1);break;}
        }
if (ftStatus)
        {
        MessageBox(0, "    ","Error",MB_OK);
        } 
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox1Change(TObject *Sender)
{
if (hPort!=NULL)
        {
        Form1->mode=ComboBox1->ItemIndex;
        SetMode(Form1->mode);
        }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
if (CheckBox1->Checked==true)
        ComboBox6->Enabled=true;
else
        ComboBox6->Enabled=false;
}
//---------------------------------------------------------------------------

