//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "D2xx.h"
#include "Func.h"
#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <string.h>

//---------------------------------------------------------------------------
#pragma package(smart_init)

//*****************   
int SearchDevices(TMenuItem ** DevList, char ** BufPtrs)
{
FT_STATUS ftStatus;
DWORD numDev;

if (Form1->hPort!=NULL)
        {FT_Close(Form1->hPort); Form1->hPort=NULL;}
EnDis(false);
        
// --     
for (int i=0;i<4;i++)
        {
        (DevList[i])->Enabled=false;
        }
(DevList[0])->Caption=" 1";
(DevList[1])->Caption=" 2";
(DevList[2])->Caption=" 3";
(DevList[3])->Caption=" 4";

ftStatus = FT_ListDevices(BufPtrs,&numDev,FT_LIST_ALL|FT_OPEN_BY_DESCRIPTION);        //    
if (FT_SUCCESS(ftStatus))
        {
        if (numDev>4)
                {return 0;  }
        for (int i=0;i<(int)numDev;i++)
                {
                (DevList[i])->Caption=BufPtrs[i];
                (DevList[i])->Enabled=true;
                }
        }
else
        {
        return 0;
        }

return 1;
}

//************     ,    
int EnDis(bool tmp)
{
Form1->Button1->Enabled=tmp;
Form1->ComboBox1->Enabled=tmp;
Form1->ComboBox2->Enabled=tmp;
Form1->CheckBox1->Enabled=tmp;
Form1->Label11->Enabled=tmp;
return 1;
}

//-----------   
int WritePort(char * mes, int len, int zikl,long *Time)
{
DWORD numin,dwRx=0,dwTx=0,dwEvent;
FT_STATUS ftStatus;
int err=1, i=0;

LARGE_INTEGER PerformanceCount1,PerformanceCount2, freq;
LONGLONG res;
double T, period;

QueryPerformanceFrequency(&freq);
T=(double)1/(freq.QuadPart);

QueryPerformanceCounter(&PerformanceCount1);
while (i<zikl)
{
ftStatus=FT_GetStatus(Form1->hPort,&dwRx,&dwTx,&dwEvent);
if (ftStatus!=FT_OK)
        {
        // 
        }

if ((4096-dwTx)>=(DWORD)len)       // ,      
        {
                ftStatus=FT_Write(
                Form1->hPort,
                mes,
                len,
                &numin);
                if (ftStatus==FT_OK)
                        {
                        //  
                        }
                else
                        {//  
                        err=0;        //    ,   
                        }
        i++;
        }
}
QueryPerformanceCounter(&PerformanceCount2);
res=PerformanceCount2.QuadPart-PerformanceCount1.QuadPart;
period=T*(res-5);
*Time=(long)(period*1000000); //     

return err;
}

//-**************         Bit Mode (2232  Only Bit Bang  2xx)
int SetMode(int mode)
{
UCHAR Mask,Mode=0;
FT_STATUS ftStatus;
int ind=0;

if (mode==0)            //   Mode
        Mode=0x00;
else
        Mode=(UCHAR)pow(2,(mode-1));

Mask=0x00;              //   Mask
if (Form1->CheckBox6->Checked==false) Mask=Mask+0x01;
if (Form1->CheckBox7->Checked==false) Mask=Mask+0x02;
if (Form1->CheckBox8->Checked==false) Mask=Mask+0x04;
if (Form1->CheckBox9->Checked==false) Mask=Mask+0x08;
if (Form1->CheckBox10->Checked==false) Mask=Mask+0x10;
if (Form1->CheckBox11->Checked==false) Mask=Mask+0x20;
if (Form1->CheckBox12->Checked==false) Mask=Mask+0x40;
if (Form1->CheckBox13->Checked==false) Mask=Mask+0x80;

if (mode!=0)
        {
        for (ind=6;ind<14;ind++)
                {
                ((TCheckBox *)Form1->FindComponent("CheckBox"+IntToStr(ind)))->Enabled=false;    //  CheckBox- ""

                if (((TCheckBox *)Form1->FindComponent("CheckBox"+IntToStr(ind)))->Checked==true)       //   CheckBox-,    
                            ((TCheckBox *)Form1->FindComponent("CheckBox"+IntToStr(ind+8)))->Enabled=false;
                }
        Form1->Button5->Enabled=true;
        }
else
        {
        for (ind=6;ind<22;ind++)
                ((TCheckBox *)Form1->FindComponent("CheckBox"+IntToStr(ind)))->Enabled=true;    //  CheckBox-     Bit Bang

        Form1->Button5->Enabled=false;
        }

ftStatus=FT_Purge(Form1->hPort,FT_PURGE_RX|FT_PURGE_TX);
if (ftStatus!=FT_OK)
        MessageBox(0,"    I/O","Error",MB_OK|MB_ICONERROR);

ftStatus=FT_SetBitMode(Form1->hPort,Mask,Mode);
if (ftStatus!=FT_OK)
        MessageBox(0,"   Bit Mode","Error",MB_OK);

ftStatus=FT_Purge(Form1->hPort,FT_PURGE_RX|FT_PURGE_TX);
if (ftStatus!=FT_OK)
        {
        //        MessageBox(0,"    I/O","Error",MB_OK|MB_ICONERROR);
        }

Form1->OutByteSet();
return 1;
}
